% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OneArmTTEDesign.R
\name{OneArmTTEDesign}
\alias{OneArmTTEDesign}
\title{Get operating characteristics of one-arm clinical trial design with time-to-event endpoint}
\usage{
OneArmTTEDesign(
  n,
  eventRates.ctrl,
  eventRates,
  enrollRates,
  dropoutRates,
  cutTime,
  landmark,
  Event = FALSE,
  n.event,
  RWdata = NULL,
  RWSurvCal = FALSE,
  conf.type = "plain",
  alpha = 0.05,
  nsim = 10000,
  seed = 43
)
}
\arguments{
\item{n}{Number of subjects.}

\item{eventRates.ctrl}{Event rates of historical control.}

\item{eventRates}{Event rates of subjects in the trial.}

\item{enrollRates}{Enrollment rates of subjects in the trial.}

\item{dropoutRates}{Dropout rates of the subjects in the trial.}

\item{cutTime}{Analysis time after last patient in; not used if Event=TRUE.}

\item{landmark}{The landmark of interest to evaluate the survival rate for Landmark Kaplan-Meier method.}

\item{Event}{Indicator of whether the analysis is driven by number of events; default is FALSE.}

\item{n.event}{Number of events at analysis; not used if Event=FALSE.}

\item{RWdata}{The real world data to be used as external control; A tibble/data.frame containing \code{time} and \code{censor}, where \code{censor=1} indicates event; default is NULL.}

\item{RWSurvCal}{Indicator of whether to calculate historical cumulative hazard and survival rate at landmark from real world data as the null case; default is FALSE.}

\item{conf.type}{Type of confidence interval in the survival model; One of "\code{none}", "\code{plain}" (the default), "\code{log}", "\code{log-log}", "\code{logit}" or "\code{arcsin}".}

\item{alpha}{Type I error rate level.}

\item{nsim}{Number of simulations; default is 10000.}

\item{seed}{Seed for simulation.}
}
\value{
No visible return values.
}
\description{
Using simulation, this function can get operating characterisitics of several approaches for
one-arm trial design with time-to-event endpoint. Default approaches include one-sample log-rank
test, Landmark Kaplen-Meier method and binary method which regards the survival of each subject
at a landmark is a binary variable. In addition, if \code{RWdata} is not \code{NULL}, the \code{RWdata}
input will be used as an external control and cox model will be used to evaluate the treatment effect
of simulated data (experimental arm) compared with the external control. The output includes
probability of rejecting null hypothesis of each design, average number of events at analysis,
and average analysis time after last patient in. When \code{eventRates} is same as \code{eventRates.ctrl},
the probability of rejecting null hypothesis is type I error; When \code{eventRates} is the alternative
hypothesis from desirable treatment effect, the probability of rejecting null hypothesis is power.
}
\details{
The function output a list of the operating characteristics including:
         1) probability of rejecting null hypothesis of each design,
          2) average number of events at analysis,
        3) average analysis time after last patient in.
}
\examples{
\donttest{
library(survival)
# Piecewise exponential of historical control
median.ctrl <- c(14.3, 1.5, 4.9)
eventRates.ctrl <- tibble::tibble(duration=c(4,2,100),rate=log(2)/median.ctrl)
# Piecewise exponential assumption of treatment:
# Hazard ratio = 1 for time 0-3 and Hazard ratio = 0.47 after
eventRates.trt = tibble::tibble(duration=c(3,1,2,100),rate=log(2)/c(14.3, median.ctrl/0.47))
# Constant enrollment rates and dropout rates
enrollRates = tibble::tibble(duration=106, rate=14/3)
dropoutRates = tibble::tibble(duration=106, rate=0.2/12)
OneArmTTEDesign(n=40, eventRates.ctrl, eventRates.trt, enrollRates, dropoutRates, cutTime=3,
                landmark=6, Event=FALSE, conf.type = 'plain', alpha=0.05, nsim=100, seed=43)
}
}
