% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpeNoise.R
\name{AcuDNPercentile}
\alias{AcuDNPercentile}
\title{Calculate reverse Percentile for period}
\usage{
AcuDNPercentile(df, parameter, from, to, period)
}
\arguments{
\item{df}{is a dataframe with Leq data}

\item{parameter}{is a parameter, example "LAeq"}

\item{from}{is start hour}

\item{to}{is end hour}

\item{period}{is a period night or day}
}
\value{
a list of acoustic percentil values by night and daily period
}
\description{
Returns a vector of acoustic percetile
}
\examples{
# Calculate reverse quantile of a dataframe by period

data("exampleHourlyData")

AcuDNPercentile(df = exampleHourlyData,
                parameter = "leq",
                from = "5",
                to = "22",
                period = "night")[1:5]

}
\author{
Pasquale Scordino \email{p.scordino@arpa.piemonte.it}

Simone Sperotto \email{s.sperotto@arpa.piemonte.it}
}
