% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listOMLRuns.R
\name{listOMLRuns}
\alias{listOMLRuns}
\title{List the first 5000 OpenML runs.}
\usage{
listOMLRuns(
  task.id = NULL,
  flow.id = NULL,
  run.id = NULL,
  uploader.id = NULL,
  tag = NULL,
  limit = 5000,
  offset = NULL,
  verbosity = NULL
)
}
\arguments{
\item{task.id}{[\code{integer}]\cr
a single ID or a vector of IDs of the task(s).}

\item{flow.id}{[\code{integer}]\cr
a single ID or a vector of IDs of the flow(s).}

\item{run.id}{[\code{integer}]\cr
a single ID or a vector of IDs of the run(s).}

\item{uploader.id}{[\code{integer}]\cr
a single ID or a vector of IDs of uploader profile(s).}

\item{tag}{[\code{character}]\cr
If not \code{NULL} only entries with the corresponding \code{tag}s
are listed.}

\item{limit}{[\code{numeric(1)}]\cr
Optional. The maximum number of entries to return. 
Without specifying \code{offset}, it returns the first '\code{limit}' entries.
Setting \code{limit = NULL} returns all available entries.}

\item{offset}{[\code{numeric(1)}]\cr
Optional. The offset to start from. 
Should be indices starting from 0, which do not refer to IDs. 
Is ignored when no \code{limit} is given.}

\item{verbosity}{[\code{integer(1)}]\cr
Print verbose output on console? Possible values are:\cr
\code{0}: normal output,\cr
\code{1}: info output,\cr
\code{2}: debug output.\cr
Default is set via \code{\link{setOMLConfig}}.}
}
\value{
[\code{data.frame}].
}
\description{
This function returns information on all OpenML runs that match certain
\code{task.id}(s), \code{run.id}(s), flow ID \code{flow.id} and/or
\code{uploader.id}(s). Alternatively the function can be passed a single
\code{tag} to list only runs with the corresponding tag associated.
Note that by default only the first 5000 runs will be returned (due to the argument \dQuote{limit = 5000}).
}
\note{
This function is memoised. I.e., if you call this function twice in a running R session,
the first call will query the server and store the results in memory while the second and all subsequent calls will return
the cached results from the first call.
You can reset the cache by calling \code{\link[memoise]{forget}} on the function manually.
}
\examples{
# \dontrun{
#   runs_ctree = listOMLRuns(flow.id = 2569)
#   head(runs_ctree)
# }
}
\seealso{
Other listing functions: 
\code{\link{chunkOMLlist}()},
\code{\link{listOMLDataSetQualities}()},
\code{\link{listOMLDataSets}()},
\code{\link{listOMLEstimationProcedures}()},
\code{\link{listOMLEvaluationMeasures}()},
\code{\link{listOMLFlows}()},
\code{\link{listOMLSetup}()},
\code{\link{listOMLStudies}()},
\code{\link{listOMLTaskTypes}()},
\code{\link{listOMLTasks}()}

Other run-related functions: 
\code{\link{convertOMLMlrRunToBMR}()},
\code{\link{convertOMLRunToBMR}()},
\code{\link{deleteOMLObject}()},
\code{\link{getOMLRun}()},
\code{\link{makeOMLRunParameter}()},
\code{\link{makeOMLRun}()},
\code{\link{tagOMLObject}()},
\code{\link{uploadOMLRun}()}
}
\concept{listing functions}
\concept{run-related functions}
