% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpenRange_load_species.R
\name{OpenRange_load_species}
\alias{OpenRange_load_species}
\title{Load Open Range maps for specified species.}
\usage{
OpenRange_load_species(
  species,
  default_only = TRUE,
  projection = 4326,
  scenario = "present",
  ...
)
}
\arguments{
\item{species}{A single species or a vector of species.}

\item{default_only}{Logical. Should only default ranges be included? Default is TRUE.}

\item{projection}{Numeric. What projection should maps be returned in?  4326 (default) or 3857}

\item{scenario}{Which climate scenario(s) should be represented by maps?  See BIEN_ranges_list_scenarios for options.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
A SpatialPolygonsDataFrame containing range maps for the specified species.
}
\description{
OpenRange_load_species returns spatial data for the specified species.
}
\examples{
\donttest{
#' 
library(maps)
library(ggplot2)
library(sf)

species_vector <- c("Abies_lasiocarpa","Abies_amabilis")
abies_maps <- OpenRange_load_species(species = species_vector)

# To get all maps for a species, use "default = FALSE".
# Here, this returns maps with different thresholds from the same model
std_all <- OpenRange_load_species(species = "Stellaria debilis",
                                  default_only = FALSE)

#To just get the default map, use "default = TRUE"
std_default <- OpenRange_load_species(species = "Stellaria debilis",
                                      default_only = TRUE)

#get world map

world <- map("world", plot = FALSE, fill = TRUE)|>
  st_as_sf()

#Plotting ranges

ggplot(data = world)+
  geom_sf()+
  geom_sf(data = abies_maps,
          mapping = aes(fill = species),
          alpha=0.5)+
  coord_sf(xlim = st_bbox(abies_maps)[c(1,3)],
           ylim = st_bbox(abies_maps)[c(2,4)]) +
  theme_bw()

}
}
\seealso{
Other range functions: 
\code{\link{OpenRange_api_load_species}()},
\code{\link{OpenRange_api_species}()},
\code{\link{OpenRange_get_license}()},
\code{\link{OpenRange_get_stats}()},
\code{\link{OpenRange_list_scenarios}()},
\code{\link{OpenRange_sf}()},
\code{\link{OpenRange_species}()}
}
\concept{range functions}
