% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preparation.R
\name{data_preparation}
\alias{data_preparation}
\title{Function to prepare the data into designated format}
\usage{
data_preparation(df, min_value = NULL)
}
\arguments{
\item{df}{dataset with each column representing a variable name paired with its value and each row representing a graph}

\item{min_value}{auxiliary point in the graph, default is min(df)/2}
}
\value{
df
}
\description{
Function to prepare the data into designated format
}
\details{
This function takes a single-row dataframe as input and output a formatted dataframe.
It introduces an auxiliary point for each variable, positioned equidistantly from the central point along auxiliary axes.
Users can customize the distance from the point to the center.
Without user customization, the distance defaults to half of the smallest value within the dataset.
}
\examples{
data(sucra)
data_preparation(sucra,min_value=0.15)

}
