% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AgainStart.R
\docType{data}
\name{WHEATUSA2004}
\alias{WHEATUSA2004}
\title{USA Wheat Surface 2004}
\format{
A data frame with 30 observations on the following 2 variables: 
\itemize{
\item \code{states} (a factor with levels \code{AR}, \code{CA}, \code{CO}, \code{DE}, \code{GA}, \code{ID}, \code{IL}, \code{IN}, \code{KS}, \code{KY}, \code{MD}, \code{MI}, \code{MO}, \code{MS}, \code{MT}, \code{NC}, \code{NE}, \code{NY}, \code{OH}, \code{OK}, \code{OR}, \code{Other}, \code{PA}, \code{SC}, \code{SD}, \code{TN}, \code{TX}, \code{VA}, \code{WA}, and \code{WI})
\item \code{acres} (wheat surface area measured in thousands of acres)
}
}
\usage{
WHEATUSA2004
}
\description{
USA's 2004 harvested wheat surface by state
}
\examples{
ggplot(data = WHEATUSA2004, aes(x = reorder(states, acres), y = acres)) + 
geom_bar(stat = "identity", color = "gold", fill = "yellow") + coord_flip() + 
labs(x = "") 
}
\references{
Ugarte, M. D., Militino, A. F., and Arnholt, A. T. 2015. \emph{Probability and Statistics with R}, Second Edition. Chapman & Hall / CRC.
}
\keyword{datasets}
