% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_random_precision_mat.R
\name{make_random_precision_mat}
\alias{make_random_precision_mat}
\title{Generate unstructured/random network skeleton and simulates corresponding precision matrix}
\usage{
make_random_precision_mat(
  eta = 0.01,
  p = 20,
  lower = 0.2,
  upper = 0.5,
  diag = 0.1
)
}
\arguments{
\item{eta}{A number between 0 and 1, the probability for drawing an edge between two arbitrary vertices, i.e. the sparsity of the network.}

\item{p}{A positive integer, the number of vertices.}

\item{lower}{A positive number, lower limits of the uniform distribution.}

\item{upper}{A positive number, upper limits of the uniform distribution.}

\item{diag}{A small positive number to be added to diagonal elements, which guarantees the precision matrix is positive definite.}
}
\value{
A precision matrix of size p by p.
}
\description{
A utility function generates unstructured/random network skeleton and simulates corresponding precision matrix. The non-zero elements of the precision matrix are generated randomly from a uniform distribution with parameters (-upper, -lower) UNION (lower, upper).
}
\examples{
Omega = make_random_precision_mat(eta=.2, p=10)
}
