% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HYPTEST.R
\name{HYPTEST}
\alias{HYPTEST}
\title{HYPTEST}
\usage{
HYPTEST(
  B,
  B0,
  Se,
  test = "two",
  variables = seq(1, nrow(B)),
  individuals = seq(1, ncol(B))
)
}
\arguments{
\item{B}{A dataframe of Coefficients as obtained in the output of any function in the package.}

\item{B0}{A dataframe of hypothetical coefficients to be evaluated in the test. (nrows should match number of variables and ncols should match number of individuals)}

\item{Se}{A dataframe of Standard Errors as obtained in the output of any function in the package.}

\item{test}{A string to determine what kind of test to run ("two" for two-tailed, "right" for right-tailed and "left for left-tailed).}

\item{variables}{A list of variables whose coefficients are to be tested. Default is all variables in the B dataframe.}

\item{individuals}{A list of individuals whose coefficients are to be tested. Default is all individuals in the B dataframe.}
}
\value{
A dataframe of p-values resulting from each individual test.
}
\description{
This function undergoes hypothesis testing for regression coefficients obtained from the various functions in the package.
}
\examples{
fit <- PDMIFLOGIT(data2X,data2Y,2,20,0.5)
HYPTEST(fit$Coefficients,data.frame(c(0,1),c(-1,2)),fit$Se,"two",c(1,3),c(1,2))
}
