% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uniform.R
\name{Uniform}
\alias{Uniform}
\title{Uniform designs}
\usage{
Uniform(mat)
}
\arguments{
\item{mat}{The matrix of the RBIBD.}
}
\value{
A LIST of:
\enumerate{
 \item[\code{n}] Number of experiments.
 \item[\code{F}] The dimension of the design.
 \item[\code{UD}] The configuration of the uniform design.
}
}
\description{
Builds the uniform design (UD) using a Resolvable Balanced Incomplete
Block Design (RBIBD)
}
\examples{
\dontrun{

m<-4
X<-BIB(m)

n<-1
mat<-X$BIB
Y<-Resolvable(n,mat)

ud<-Uniform(Y$RBIB)  #Uniform design
}
}
\references{
Fang.K.T et al., Constructions of uniform designs by
using resolvable packings and coverings. Discrete Math. (19), 2003, 692-711.

Fang.K.T et al., Construction of uniform designs via super-simple
resolvable t-designs. Util. Math. (66).2004, 15-32.
}
\author{
Mohamed Laib, Abla Boudraa and Zebida Gheribi-Aoulmi
}
