% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_abundance.R
\name{plot_abundance}
\alias{plot_abundance}
\title{Plot of feature abundance level}
\usage{
plot_abundance(result, data, Treatment)
}
\arguments{
\item{result}{Clustering result from function PHclust().}

\item{data}{Data matrix with dimension N*P indicating N features and P samples.}

\item{Treatment}{Vector of length P. Indicating replicates of different treatment groups. For example, \emph{Treatment} = c(1,1,2,2,3,3) indicates 3 treatment groups, each with 2 replicates.}
}
\value{
A plot for feature abundance level will be shown. No value is returned.
}
\description{
This function plots the feature abundance level for each cluster, after extracting the effect of sample-wise normalization factors and feature-wise geometric mean.
}
\examples{
######## Run the following codes in order:
##
## This is a sample data set which has 100 features, and 4 treatment groups with 4 replicates each.
data('sample_data')
head(sample_data)
set.seed(1)
##
## Finding the optimal number of clusters
K <- Hybrid(sample_data, Kstart = 4, Treatment = rep(c(1,2,3,4), each = 4))
##
## Clustering result from EM algorithm
result <- PHcluster(sample_data, rep(c(1,2,3,4), each = 4), K, method = 'EM', nstart = 1)
print(result$cluster)
##
## Plot the feature abundance level for each cluster
plot_abundance(result, sample_data, Treatment = rep(c(1,2,3,4), each = 4))
}
