% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLreg.R
\name{extra.parameter}
\alias{extra.parameter}
\title{Procedure to Select the Extra Parameter for PLreg Objects}
\usage{
extra.parameter(object, lower, upper, grid = 10, graph = TRUE)
}
\arguments{
\item{object}{fitted model object of class "\code{PLreg}".}

\item{lower}{a numeric value representing the lower limit of the interval for
the extra parameter.}

\item{upper}{a numeric value representing the upper limit of the interval for
the extra parameter.}

\item{grid}{a positive integer representing the number of points in the plots.
Default is \code{grid=10}. If \code{grid} is less than 10, then \code{grid=10}.}

\item{graph}{logical. If \code{graph = TRUE} the plots are shown, if
\code{graph = FALSE} the plots are not shown. Default is \code{graph = TRUE}.}
}
\value{
\code{extra.parameter} returns a list with five objects:
\item{zeta.Ups}{The selected zeta based on the Upsilon measure.}
\item{zeta.loglik}{The selected zeta based on -2\code{logLik}.}
\item{zeta.values}{The values of zeta used in the graphs.}
\item{Upsilon.values}{-2\code{logLik} evaluated at each value of zeta.}
\item{loglik.values}{Upsilon measure evaluated at each value of zeta.}
}
\description{
The \code{extra.parameter} function is used to select the extra parameter
of some power logit models. It provides plots of -2\code{logLik} and the
Upsilon measure (see Queiroz and Ferrari (2022)) versus \eqn{\zeta},
the extra parameter.
}
\examples{
data("bodyfat_Aeolus")

#Initial model with zeta = 2
fit1 <- PLreg(percentfat ~ days + sex + year, data = bodyfat_Aeolus,
             family = "PE", zeta = 2)
summary(fit1)
# Choosing the best value for zeta
\donttest{
extra.parameter(fit1, lower = 1, upper = 4, grid = 15)}
}
\references{
Queiroz, F. F. and Ferrari, S. L. P. (2022). Power logit regression
for modeling bounded data. \emph{arXiv}:2202.01697.
}
\seealso{
\code{\link{PLreg}}
}
