% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_km_survival_curve.R
\name{get_km_survival_curve}
\alias{get_km_survival_curve}
\title{Plot Kaplan-Meier survival curve.}
\usage{
get_km_survival_curve(km_data, cut_point, TRAIN = TRUE, risk.table = TRUE)
}
\arguments{
\item{km_data}{A data frame, including survival status, survival time, and risk score of each sample. The data frame can be generated by the function `get_risk_score`.}

\item{cut_point}{The threshold uses to classify patients into two subgroups with different OS.}

\item{TRAIN}{Logical,if set to TRUE,the 'cut_point' is generated by the median of the risk score; Otherwise,'cut_point' can be customized.}

\item{risk.table}{Allowed values include:TRUE or FALSE specifying whether to show or not the risk table. Default is FALSE.}
}
\value{
No return, plot the Kaplan-Meier survival curve.
}
\description{
The function `get_km_survival_curve` uses to draw the Kaplan-Meier survival curve.
}
\examples{
#load the data.
data(km_data)
#perform the function `get_km_survival_curve`.
get_km_survival_curve(km_data,cut_point,TRAIN = TRUE,risk.table=TRUE)
}
