% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kwAllPairsNemenyiTest.R
\name{kwAllPairsNemenyiTest}
\alias{kwAllPairsNemenyiTest}
\alias{kwAllPairsNemenyiTest.default}
\alias{kwAllPairsNemenyiTest.formula}
\title{Nemenyi's All-Pairs Rank Comparison Test}
\usage{
kwAllPairsNemenyiTest(x, ...)

\method{kwAllPairsNemenyiTest}{default}(x, g, dist = c("Tukey", "Chisquare"), ...)

\method{kwAllPairsNemenyiTest}{formula}(
  formula,
  data,
  subset,
  na.action,
  dist = c("Tukey", "Chisquare"),
  ...
)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{dist}{the distribution for determining the p-value.
Defaults to \code{"Tukey"}.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
\item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
\item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs Nemenyi's non-parametric all-pairs comparison test
for Kruskal-type ranked data.
}
\details{
For all-pairs comparisons in an one-factorial layout
with non-normally distributed residuals Nemenyi's non-parametric test
can be performed. A total of \eqn{m = k(k-1)/2}
hypotheses can be tested. The null hypothesis
H\eqn{_{ij}: \theta_i(x) = \theta_j(x)} is tested in the two-tailed test
against the alternative
A\eqn{_{ij}: \theta_i(x) \ne \theta_j(x), ~~ i \ne j}.

Let \eqn{R_{ij}} be the rank of \eqn{X_{ij}},
where \eqn{X_{ij}} is jointly ranked
from \eqn{\left\{1, 2, \ldots, N \right\}, ~~ N = \sum_{i=1}^k n_i},
then the test statistic under the absence of ties is calculated as

\deqn{
t_{ij} = \frac{\bar{R}_j - \bar{R}_i}
{\sigma_R \left(1/n_i + 1/n_j\right)^{1/2}} \qquad \left(i \ne j\right),
}{%
 SEE PDF
}

with \eqn{\bar{R}_j, \bar{R}_i} the mean rank of the
\eqn{i}-th and \eqn{j}-th group and the expected variance as
\deqn{
 \sigma_R^2 = N \left(N + 1\right) / 12.
}{%
 SEE PDF
}

A pairwise difference is significant, if \eqn{|t_{ij}|/\sqrt{2} > q_{kv}},
with \eqn{k} the number of groups and \eqn{v = \infty}
the degree of freedom.

Sachs(1997) has given a modified approach for
Nemenyi's test in the presence of ties for \eqn{N > 6, k > 4}
provided that the \code{\link{kruskalTest}} indicates significance:
In the presence of ties, the test statistic is
corrected according to \eqn{\hat{t}_{ij} = t_{ij} / C}, with
\deqn{
  C = 1 - \frac{\sum_{i=1}^r t_i^3 - t_i}{N^3 - N}.
}{%
 SEE PDF
}

The function provides two different \code{dist}
for \eqn{p}-value estimation:
\describe{
\item{Tukey}{The \eqn{p}-values are computed from the studentized
range distribution (alias \code{\link[stats]{Tukey}}),
\eqn{\mathrm{Pr} \left\{ t_{ij} \sqrt{2} \ge q_{k\infty\alpha} | mathrm{H} \right\} = \alpha}.}
\item{Chisquare}{The \eqn{p}-values are computed from the
\code{\link[stats]{Chisquare}} distribution with \eqn{v = k - 1} degree
of freedom.}
}
}
\examples{
## Data set InsectSprays
## Global test
kruskalTest(count ~ spray, data = InsectSprays)

## Conover's all-pairs comparison test
## single-step means Tukey's p-adjustment
ans <- kwAllPairsConoverTest(count ~ spray, data = InsectSprays,
                             p.adjust.method = "single-step")
summary(ans)

## Dunn's all-pairs comparison test
ans <- kwAllPairsDunnTest(count ~ spray, data = InsectSprays,
                             p.adjust.method = "bonferroni")
summary(ans)

## Nemenyi's all-pairs comparison test
ans <- kwAllPairsNemenyiTest(count ~ spray, data = InsectSprays)
summary(ans)

## Brown-Mood all-pairs median test
ans <- medianAllPairsTest(count ~ spray, data = InsectSprays)
summary(ans)
}
\references{
Nemenyi, P. (1963) \emph{Distribution-free Multiple Comparisons}.
Ph.D. thesis, Princeton University.

Sachs, L. (1997) \emph{Angewandte Statistik}. Berlin: Springer.

Wilcoxon, F., Wilcox, R. A. (1964)
\emph{Some rapid approximate statistical procedures}.
Pearl River: Lederle Laboratories.
}
\seealso{
\code{\link[stats]{Tukey}}, \code{\link[stats]{Chisquare}},
\code{\link[stats]{p.adjust}}, \code{\link{kruskalTest}},
\code{\link{kwAllPairsDunnTest}}, \code{\link{kwAllPairsConoverTest}}
}
\concept{kruskalranks}
\keyword{htest}
\keyword{nonparametric}
