\name{crime_W}
\alias{crime_W}
\docType{data}
\title{
Network matrix for Chicago crime dataset
}
\description{
Non-negative row-normized adjacency matrix describing the network structure
between Chicago census blocks.
}
\usage{crime_W}
\format{
A matrix with 552 rows and 552 columns.
}
\source{
Clark and Dixon (2021), available at \url{https://github.com/nick3703/Chicago-Data}.
}
\references{
Clark, N. J. and P. M. Dixon (2021). A class of spatially correlated
self-exciting statistical models. \emph{Spatial Statistics}, 43, 1--18.
}
\seealso{
\code{\link{crime}, \link{lin_estimnarpq}, \link{log_lin_estimnarpq}
}
}
\examples{
data(crime)
data(crime_W)
mod1 <- lin_estimnarpq(crime, crime_W, p = 1)
mod2 <- log_lin_estimnarpq(crime, crime_W, p = 1)
}
