% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_MADE.min_studies.R
\name{plot_MADE.min_studies}
\alias{plot_MADE.min_studies}
\title{Plot function for a 'min_studies' object}
\usage{
\method{plot_MADE}{min_studies}(
  data,
  v_lines = NULL,
  legend_position = "bottom",
  color = TRUE,
  numbers = TRUE,
  number_size = 2.5,
  numbers_ynudge = NULL,
  caption = TRUE,
  x_lab = NULL,
  x_breaks = NULL,
  x_limits = NULL,
  y_breaks = ggplot2::waiver(),
  y_limits = NULL,
  y_expand = NULL,
  warning = TRUE,
  traffic_light_assumptions = NULL,
  v_shade = NULL,
  h_lines = NULL,
  ...
)
}
\arguments{
\item{data}{Data/object for which the plot should be made.}

\item{v_lines}{Integer or vector to specify vertical line(s) in within each
plot. Default is \code{NULL}.}

\item{legend_position}{Character string to specify position of legend. Default is \code{"bottom"}.}

\item{color}{Logical indicating whether to use color in the plot(s). Default is \code{TRUE}.}

\item{numbers}{Logical indicating whether to number the plots. Default is \code{TRUE}.}

\item{number_size}{Integer value specifying the size of the (optional) plot
numbers. Default is \code{2.5}.}

\item{numbers_ynudge}{Integer value for vertical nudge of the (optional) plot
numbers.}

\item{caption}{Logical indicating whether to include a caption with detailed
information regarding the analysis. Default is \code{TRUE}.}

\item{x_lab}{Title for the x-axis. If \code{NULL} (the default), the x_lab is
specified automatically.}

\item{x_breaks}{Optional vector to specify breaks on the x-axis. Default is \code{NULL}.}

\item{x_limits}{Optional vector of length 2 to specify the limits of the
x-axis. Default is \code{NULL}, which allows limits to be determined automatically from the data.}

\item{y_breaks}{Optional vector to specify breaks on the y-axis.}

\item{y_limits}{Optional vector of length 2 to specify the limits of the
y-axis.}

\item{y_expand}{Optional vector to expand the limits of the y-axis. Default is \code{NULL}.}

\item{warning}{Logical indicating whether warnings should be returned when
multiple models appear in the data. Default is \code{TRUE}.}

\item{traffic_light_assumptions}{Optional logical to specify coloring of
strips of the facet grids to emphasize assumptions about the likelihood the
given analytical scenario. See Vembye, Pustejovsky, & Pigott (In
preparation) for further details.}

\item{v_shade}{Optional vector of length 2 specifying the range of the x-axis
interval to be shaded in each plot.}

\item{h_lines}{Optional integer or vector specifying horizontal lines on each
plot.}

\item{...}{Additional arguments available for some classes of objects.}
}
\value{
A \code{ggplot} plot showing the minimum number of studies needed to
obtain a given effect size with a certain amount of power and level-alpha, faceted
across levels of the within-study SD and the between-study SD,
with different colors, lines, and shapes corresponding to different values
of the assumed sample correlation. If \code{length(unique(data$mu)) > 1}, it
returns a \code{ggplot} plot showing the minimum studies needed
to obtained a given effect size with a certain amount of power and
level-alpha across effect sizes of practical concern, faceted by the
between-study and within-study SDs, with different colors, lines, and
shapes corresponding to different values of the assumed sample correlation.
}
\description{
Creates a faceted plot with analyses of the minimum number of
studies needed to obtained a given effect size with specified levels of
power, as calculated using \code{min_studies_MADE}.
}
\details{
In general, it can be rather difficult to guess/approximate the true
model parameters and sample characteristics a priori. Calculating the
minimum number of studies needed under just a single set of assumptions can
easily be misleading even if the true model and data structure only
slightly diverge from the yielded data and model assumptions. To maximize
the informativeness of the analysis, Vembye, Pustejovsky, &
Pigott (In preparation) suggest accommodating the uncertainty of the power
approximations by reporting or plotting power estimates across a range of
possible scenarios, which can be done using \code{plot_MADE.power}.
}
\examples{
min_studies_MADE(
  mu = c(0.25, 0.35),
  tau = 0.05,
  omega = 0.02,
  rho = 0.2,
  target_power = .7,
  sigma2_dist = 4 / 200,
  n_ES_dist = 6,
  seed = 10052510
) |>
  plot_MADE(y_breaks = seq(0, 10, 2), numbers = FALSE)

}
\references{
Vembye, M. H., Pustejovsky, J. E., & Pigott, T. D. (In
preparation). Conducting power analysis for meta-analysis of dependent
effect sizes: Common guidelines and an introduction to the POMADE R
package.
}
\seealso{
\code{\link{plot_MADE}}
}
