% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DMACA-PSSM.R
\name{DFMCA_PSSM}
\alias{DFMCA_PSSM}
\title{DMACA-PSSM feature}
\usage{
DFMCA_PSSM(pssm_name, n = 7)
}
\arguments{
\item{pssm_name}{name of PSSM Matrix file}

\item{n}{A parameter called the window size that must be smaller than the length of the sequence}
}
\value{
feature vector of length 210
}
\description{
In this feature each column of PSSM Matrix, can be regarded as a time series. Each PSSM
contains 20 columns Hence, each PSSM can be considered as 20 time series.The detrended moving-average
cross-correlation analysis (DMCA) is developed to measure the level of cross-correlation between two
non-stationary time series by fusing the detrended cross-correlation analysis (DCCA) and the detrended
moving average(DMA).this function utilizes this algorithm for each column and each pair of columns to produce
a feature vector of length 290.
}
\note{
parameter n must be equal or greater than 3 and equal or less then L which L is length of protein
}
\examples{
X<-DFMCA_PSSM(system.file("extdata", "C7GQS7.txt.pssm", package="PSSMCOOL"),7)
}
\references{
Y. Liang, S. Zhang, S. J. S. Ding, and Q. i. E. Research, "Accurate prediction of Gram-negative bacterial secreted protein
types by fusing multiple statistical features from PSI-BLAST profile," vol. 29, no. 6, pp. 469-481, 2018.

Y. Liang and S. J. A. b. Zhang, "Prediction of apoptosis protein’s subcellular localization by fusing two different
descriptors based on evolutionary information," vol. 66, no. 1, pp. 61-78, 2018.
}
