% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSpower.R
\name{PSpower}
\alias{PSpower}
\title{Calculate sample size needed to achieve a prespecified power}
\usage{
PSpower(
  tau,
  sig.level = 0.05,
  power = NULL,
  sample.size = NULL,
  r,
  phi,
  rho_sq,
  test = "two-sided",
  estimand = "ATE"
)
}
\arguments{
\item{tau}{the anticipated standardized treatment effect}

\item{sig.level}{the significance level, or the type-I error rate (default 0.05)}

\item{power}{the desired power to achieve (only specify for sample size calculation)}

\item{sample.size}{the total sample size (only specify for power calculation)}

\item{r}{the proportion of treated units}

\item{phi}{the overlap coefficient (usually between 0.8 and 1); use function plot_overlap(r, phi) for visual aid}

\item{rho_sq}{the squared correlation between propensity score and outcome; recommend treating as a sensitivity parameter: a grid of values between 0 and the R-squared statistic of predicting the outcomes with covariates.}

\item{test}{whether one-sided or two-sided test is considered}

\item{estimand}{the estimand (ATE, ATT, ATC or ATO), or a customized tilting function h(e(x))}
}
\value{
an object with the calculated sample size
}
\description{
Calculate sample size needed to achieve a prespecified power
}
\examples{
PSpower(tau = 1/sqrt(20), sig.level = 0.05, power = 0.956, r = 0.5, phi = 0.99, rho_sq = 0.02)
}
