% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProbitRE_PoissonRE.R
\name{ProbitRE_PoissonRE}
\alias{ProbitRE_PoissonRE}
\title{Poisson RE model with Sample Selection}
\usage{
ProbitRE_PoissonRE(
  sel_form,
  out_form,
  data,
  id.name,
  testData = NULL,
  par = NULL,
  delta = NULL,
  sigma = NULL,
  rho = NULL,
  method = "BFGS",
  se_type = c("BHHH", "Hessian")[1],
  H = c(10, 10),
  psnH = 20,
  prbH = 20,
  reltol = sqrt(.Machine$double.eps),
  verbose = 1,
  offset_w_name = NULL,
  offset_x_name = NULL
)
}
\arguments{
\item{sel_form}{Formula for selection equation, a Probit model with random effects}

\item{out_form}{Formula for outcome equation, a Poisson model with random effects}

\item{data}{Input data, a data.frame object}

\item{id.name}{The name of the column representing id. Data will be sorted by id to improve estimation speed.}

\item{testData}{Test data for prediction, a data.frame object}

\item{par}{Starting values for estimates. Default to estimates of standalone selection and outcome models.}

\item{delta}{Starting value for delta. Will be ignored if par is provided.}

\item{sigma}{Starting value for sigma. Will be ignored if par is provided.}

\item{rho}{Starting value for rho. Defaults to 0 and will be ignored if par is provided.}

\item{method}{Optimization method used by optim. Defaults to 'BFGS'.}

\item{se_type}{Report Hessian or BHHH standard errors. Defaults to BHHH.}

\item{H}{A integer vector of length 2, specifying the number of points for inner and outer Quadratures}

\item{psnH}{Number of Quadrature points for Poisson RE model}

\item{prbH}{Number of Quddrature points for Probit RE model}

\item{reltol}{Relative convergence tolerance. The algorithm stops if it is unable to reduce the value by a factor of reltol * (abs(val) + reltol) at a step. Defaults to sqrt(.Machine$double.eps), typically about 1e-8.}

\item{verbose}{A integer indicating how much output to display during the estimation process.
\itemize{
\item <0 - No ouput
\item 0 - Basic output (model estimates)
\item 1 - Moderate output, basic ouput + parameter and likelihood in each iteration
\item 2 - Extensive output, moderate output + gradient values on each call
}}

\item{offset_w_name}{An offset variable whose coefficient is assumed to be 1 in the selection equation}

\item{offset_x_name}{An offset variable whose coefficient is assumed to be 1 in the outcome equation}
}
\value{
A list containing the results of the estimated model, some of which are inherited from the return of optim
\itemize{
\item estimates: Model estimates with 95\% confidence intervals
\item par: Point estimates
\item var_bhhh: BHHH covariance matrix, inverse of the outer product of gradient at the maximum
\item se_bhhh: BHHH standard errors
\item g: Gradient function at maximum
\item gtHg: \eqn{g'H^-1g}, where H^-1 is approximated by var_bhhh. A value close to zero (e.g., <1e-3 or 1e-6) indicates good convergence.
\item LL: Likelihood
\item AIC: AIC
\item BIC: BIC
\item n_obs: Number of observations
\item time: Time takes to estimate the model
\item partial: Average partial effect at the population level
\item paritalAvgObs: Partial effect for an individual with average characteristics
\item predict: A list with predicted participation probability (prob), predicted potential outcome (outcome), and predicted actual outcome (actual_outcome).
\item counts: From optim. A two-element integer vector giving the number of calls to fn and gr respectively. This excludes those calls needed to compute the Hessian, if requested, and any calls to fn to compute a finite-difference approximation to the gradient.
\item message: From optim. A character string giving any additional information returned by the optimizer, or NULL.
\item convergence: From optim. An integer code. 0 indicates successful completion.
Note that the list inherits all the complements in the output of optim. See the documentation of optim for more details.
}
}
\description{
Estimates the following two-stage model \cr \cr
Selection equation (ProbitRE - Probit model with individual level random effects):
\deqn{z_{it}=1(\boldsymbol{\alpha}\mathbf{w_{it}}'+\delta u_i+\xi_{it} > 0)}{z_it=1(\alpha*w_it'+\delta*u_i+\xi_it > 0)}
Outcome Equation (PoissonRE - Poisson with individual level random effects):
\deqn{E[y_{it}|x_{it},v_i] = exp(\boldsymbol{\beta}\mathbf{x_{it}}' + \sigma v_i)}{E[y_it | x_it,v_i] = exp(\beta*x_it' + \sigma*v_i)}
Correlation (self-selection at individual level):
\itemize{
\item \eqn{u_i} and \eqn{v_i} are bivariate normally distributed with a correlation of \eqn{\rho}.
}

Notations:
\itemize{
\item \eqn{w_{it}}{w_it}: variables influencing the selection decision \eqn{z_{it}}{z_it}, which could be a mixture of time-variant variables, time-invariant variables, and time dummies
\item \eqn{x_{it}}{x_it}: variables influencing the outcome \eqn{y_{it}}{y_it}, which could be a mixture of time-variant variables, time-invariant variables, and time dummies
\item \eqn{u_i}: individual level random effect in the selection equation
\item \eqn{v_i}: individual level random effect in the outcome equation
\item \eqn{\xi_{it}}{\xi_it}: error term in the selection equation
}
}
\examples{
\donttest{
# Use the simulated dataset, in which the true coefficients of x and w are 1 in both stages.
# The simulated dataset includes self-selection at both individual and individual-time level,
# but this model only considers self-selection at the individual level.
data(sim)
res = ProbitRE_PoissonRE(z~x+w, y~x, data=sim, id.name='id')
res$estimates
}
}
\references{
\enumerate{
\item Peng, J., & Van den Bulte, C. (2023). Participation vs. Effectiveness in Sponsored Tweet Campaigns: A Quality-Quantity Conundrum. Management Science (forthcoming). Available at SSRN: \url{https://www.ssrn.com/abstract=2702053}
\item Peng, J., & Van den Bulte, C. (2015). How to Better Target and Incent Paid Endorsers in Social Advertising Campaigns: A Field Experiment. 2015 International Conference on Information Systems. \url{https://aisel.aisnet.org/icis2015/proceedings/SocialMedia/24/}
}
}
\seealso{
Other PanelCount: 
\code{\link{PLN_RE}()},
\code{\link{PoissonRE}()},
\code{\link{ProbitRE_PLNRE}()},
\code{\link{ProbitRE}()}
}
\concept{PanelCount}
