% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultivariateMoments.R
\name{EWMAMoments}
\alias{EWMAMoments}
\alias{M2.ewma}
\alias{M3.ewma}
\alias{M4.ewma}
\title{Functions for calculating EWMA comoments of financial time series}
\usage{
M2.ewma(R, lambda = 0.97, last.M2 = NULL, ...)

M3.ewma(R, lambda = 0.97, last.M3 = NULL, as.mat = TRUE, ...)

M4.ewma(R, lambda = 0.97, last.M4 = NULL, as.mat = TRUE, ...)
}
\arguments{
\item{R}{an xts, vector, matrix, data frame, timeSeries or zoo object of
asset returns (with mean zero)}

\item{lambda}{decay coefficient}

\item{last.M2}{last estimated covariance matrix before the observed returns R}

\item{\dots}{any other passthru parameters}

\item{last.M3}{last estimated coskewness matrix before the observed returns R}

\item{as.mat}{TRUE/FALSE whether to return the full moment matrix or only
the vector with the unique elements (the latter is advised for speed), default
TRUE}

\item{last.M4}{last estimated cokurtosis matrix before the observed returns R}
}
\description{
calculates exponentially weighted moving average covariance, coskewness and cokurtosis matrices
}
\details{
The coskewness and cokurtosis matrices are defined as the matrices of dimension 
p x p^2 and p x p^3 containing the third and fourth order central moments. They
are useful for measuring nonlinear dependence between different assets of the 
portfolio and computing modified VaR and modified ES of a portfolio.

EWMA estimation of the covariance matrix was popularized by the RiskMetrics report in 1996.
The M3.ewma and M4.ewma are straightforward extensions to the setting of third and fourth
order central moments
}
\examples{

data(edhec)

# EWMA estimation
# 'as.mat = F' would speed up calculations in higher dimensions
sigma <- M2.ewma(edhec, 0.94)
m3 <- M3.ewma(edhec, 0.94)
m4 <- M4.ewma(edhec, 0.94)

# compute equal-weighted portfolio modified ES 
mu <- colMeans(edhec)
p <- length(mu)
ES(p = 0.95, portfolio_method = "component", weights = rep(1 / p, p), mu = mu, 
    sigma = sigma, m3 = m3, m4 = m4)

# compare to sample method
sigma <- cov(edhec)
m3 <- M3.MM(edhec)
m4 <- M4.MM(edhec)
ES(p = 0.95, portfolio_method = "component", weights = rep(1 / p, p), mu = mu, 
    sigma = sigma, m3 = m3, m4 = m4)

}
\references{
JP Morgan. Riskmetrics technical document. 1996.
}
\seealso{
\code{\link{CoMoments}} \cr \code{\link{ShrinkageMoments}} \cr \code{\link{StructuredMoments}} 
\cr \code{\link{MCA}} \cr \code{\link{NCE}}
}
\author{
Dries Cornilly
}
\concept{co-moments}
\concept{moments}
