% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atomProperties.R
\name{atomProperties}
\alias{atomColor}
\alias{atomProperties}
\alias{mass}
\alias{rcov}
\alias{rvdw}
\title{Atomic Properties}
\usage{
mass(x)

rcov(x)

rvdw(x)

atomColor(x)
}
\arguments{
\item{x}{an R object for which to get atomic properties.}
}
\value{
Return a vector containing atomic properties.
}
\description{
Determine atomic properties from atomic symbols, atomic numbers or atom
names.
}
\details{
The functions documented here allow to get atomic properties, such as atomic
masses (\code{mass}), covalent radii (\code{rcov}), Van der Waals radii
(\code{rvdw}) and atom colors (\code{atomColor}), from atomic symbols, atomic
numbers or atom names.

The methods for atomic number (integer or numeric values) and atom names
(character strings) first convert the values into atomic symbols (see
\code{\link{symb}}) and then match them with the \code{\link{periodicTable}}
dataset to determine the properties.
}
\examples{
# Display all chemical element properties
data(periodicTable)
periodicTable

# From atomic symbols
mass(c("C","O","H"))
rcov(c("C","O","H"))
rvdw(c("C","O","H"))
atomColor(c("C","O","H"))

# From atomic numbers
mass(c(6, 8, 1))
rcov(c(6, 8, 1))
rvdw(c(6, 8, 1))
atomColor(c(6, 8, 1))

# From atom names
mass(c("CA","OD","H"))
rcov(c("CA","OD","H"))
rvdw(c("CA","OD","H"))
atomColor(c("CA","OD","H"))

}
\seealso{
\code{\link{periodicTable}}, \code{\link{atomRecognition}},
  \code{\link{match}}
}
\keyword{utilities}

