% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm_test.R
\name{perm_test}
\alias{perm_test}
\title{Robust Permutation Tests of Correlation Coefficients}
\usage{
perm_test(
  x,
  y,
  B = 1000,
  r0 = 0,
  w = NULL,
  method = c("Pearson", "wtdPearson", "Spearman", "CCC"),
  alternative = c("two.sided", "less", "greater")
)
}
\arguments{
\item{x}{a \code{numeric} vector.}

\item{y}{a \code{numeric} vector.}

\item{B}{an \code{integer} number of permutations.}

\item{r0}{a \code{numeric} denoting the CCC under the null hypothesis. It should be in the range between
-1 and 1. This parameter will be ignored for the tests of Pearson, weighted Pearson, or Spearman's
correlation coefficient.}

\item{w}{\code{numeric} vector denoting the weights of the elements in vectors \code{x} and \code{y}.}

\item{method}{the correlation coefficient to be tested, options include Pearson's correlation coefficient
(\code{Pearson}), weighted Pearson correlation coefficient (\code{wtdPearson}),
Spearman's correlation coefficient (\code{Spearman}), Lin's concordance correlation coefficient (\code{CCC}).}

\item{alternative}{the alternative hypothesis, can be \code{two.sided}, \code{less}, or \code{greater}.}
}
\value{
\describe{
\item{\code{estimate}}{the estimated correlation coefficient.}
\item{\code{p.value}}{the p-value from the studentized test.}
\item{\code{method}}{the method for measuring correlation coefficient.}
\item{\code{alternative}}{the alternative hypothesis.}
}
}
\description{
This function performs robust permutation tests for various correlation coefficients, providing
reliable type I error control under general scenarios, especially when the sample size is small and
two variables are dependent but uncorrelated.
}
\details{
#' The test supports the following correlation coefficients: Pearson correlation coefficient, Weighted
Pearson correlation coefficient, Spearman correlation coefficient, and Lin's concordance correlation coefficient (CCC)

For Pearson, weighted Pearson, and Spearman correlation coefficients, the test supports a zero null
hypothesis. The alternative hypothesis can be either one-sided or two-sided.

For Lin's concordance correlation coefficient (CCC), the test accommodates a more general null
hypothesis. Currently, the test only supports a one-sided alternative hypothesis (greater).
}
\examples{
set.seed(123)
x <- rnorm(20)
y <- rnorm(20)
perm_test(x, y, B = 500, method = "Pearson", alternative = "greater")

perm_test(x, y, B = 500, method = "Spearman", alternative = "two.sided")

perm_test(x, y, B = 500, w = rep(0.05,20), method = "wtdPearson", alternative = "less")

perm_test(x, y, B = 500, r0 = -0.5, method = "CCC", alternative = "greater")

}
\references{
Lawrence, I., & Lin, K. (1989). A concordance correlation coefficient to evaluate reproducibility. Biometrics, 255-268.

DiCiccio, C. J., & Romano, J. P. (2017). Robust permutation tests for correlation and regression coefficients. Journal of the American Statistical Association, 112(519), 1211-1220.

Hutson, A. D., & Yu, H. (2021). A robust permutation test for the concordance correlation coefficient. Pharmaceutical Statistics, 20(4), 696-709.

Yu, H., & Hutson, A. D. (2024). A robust Spearman correlation coefficient permutation test. Communications in Statistics-Theory and Methods, 53(6), 2141-2153.

Yu, H., & Hutson, A. D. (2024). Inferential procedures based on the weighted Pearson correlation coefficient test statistic. Journal of Applied Statistics, 51(3), 481-496.
}
\author{
Mengyu Fang, Han Yu, Alan Hutson
}
