% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth_helpers.R
\name{auth_helpers}
\alias{auth_helpers}
\alias{has_local_auth}
\alias{write_auth}
\alias{reset_auth}
\title{Authentication helpers}
\usage{
has_local_auth()

write_auth(path = ".Renviron", append = TRUE)

reset_auth()
}
\arguments{
\item{path}{file path to write secrets to}

\item{append}{passed to \code{\link[=write]{write()}}}
}
\value{
\code{\link[=has_local_auth]{has_local_auth()}} returns a logical value; \code{\link[=write_auth]{write_auth()}} and
\code{\link[=reset_auth]{reset_auth()}} return \code{TRUE} invisibly upon success.
}
\description{
These functions help manage the environment variables that the PhilipsHue
package uses to store authentication secrets.
}
\details{
Local authentication requires setting two environment variables:
\code{PHILIPS_HUE_BRIDGE_IP} and \code{PHILIPS_HUE_BRIDGE_USERNAME}. \code{\link[=has_local_auth]{has_local_auth()}}
uses regular expressions to check if these variables are set (but does not
check if the credentials actually work). \code{\link[=reset_auth]{reset_auth()}} sets these variables
to empty strings, and \code{\link[=write_auth]{write_auth()}} writes the current values to a file
(e.g. an \code{.Renviron} file for use during development).
}
