% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensors_api.R
\name{configure_daylight_sensor}
\alias{configure_daylight_sensor}
\title{Configure Built-In Daylight Sensor}
\usage{
configure_daylight_sensor(
  lat,
  lon,
  sunriseoffset = 30,
  sunsetoffset = -30,
  id = 1
)
}
\arguments{
\item{lat}{latitude (in decimal degrees). Positive north; negative south.}

\item{lon}{longitude (in decimal degrees). Positive east; negative west.}

\item{sunriseoffset}{"daylight" begins \code{sunriseoffset} minutes after
sunrise}

\item{sunsetoffset}{"daylight" ends \code{sunsetoffset} minutes after sunset}

\item{id}{ID of the daylight sensor}
}
\value{
Returns \code{TRUE} (invisibly) upon success.
}
\description{
Supported sensors for the Hue bridge include a virtual daylight sensor that
calculates sunrise and sunset times based on your location. This function
helps configure the built-in daylight sensor (\code{id = 1}).
}
\seealso{
\url{https://developers.meethue.com/develop/hue-api/supported-devices/#supportred-sensors}
}
