% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{save_plot}
\alias{save_plot}
\title{Save FTIR Plot}
\usage{
save_plot(ftir_spectra_plot, filename, ...)
}
\arguments{
\item{ftir_spectra_plot}{A plot generated by [plot_ftir()] or
  [plot_ftir_stacked()].

  Un tracé généré par [plot_ftir()] ou [plot_ftir_stacked()].}

\item{filename}{Name and directory of the file you wish to create. If it includes a extension the function will produce a file of that type. Options for filetypes include "eps", "ps", "tex" (pictex), "pdf", "jpeg", "tiff", "png", "bmp", "svg" or "wmf" (on windows only).

 Nom et répertoire du fichier que vous souhaitez créer. S'il contient une extension, la fonction produira un fichier de ce type. Les options pour les types de fichiers incluent "eps", "ps", "tex" (pictex), "pdf", "jpeg", "tiff", "png", "bmp", "svg" ou "wmf" (sur Windows uniquement).}

\item{...}{Additional arguements to pass to [ggplot2::ggsave()].

 Arguments supplémentaires à passer à [ggplot2::ggsave()].}
}
\value{
invisible `TRUE`
}
\description{
Save FTIR plot object to file. Uses [ggplot2::ggsave()] to save to disk. Specify a filename ending with `.svg` for vector graphics, if requeste by a journal.

Enregistrer l'objet de tracé IRTF dans un fichier. Utilise [ggplot2::ggsave()] pour enregistrer sur le disque. Spécifier un nom de fichier se terminant par `.svg` pour les graphiques vectoriels, si un journal le demande.
}
\examples{
if (requireNamespace("ggplot2", quietly = TRUE)) {
  td <- tempdir()
  save_plot(plot_ftir(biodiesel), filename = file.path(td, "biodiesel_plot.png"))
}
}
