% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionsImmunogenicitySample.R
\name{ExtractDiseased}
\alias{ExtractDiseased}
\title{Diseased subjects extraction}
\usage{
ExtractDiseased(vaccinated, control)
}
\arguments{
\item{vaccinated}{\code{Population-class} object: vaccinated subjects with assigned disease status}

\item{control}{\code{Population-class} object: control subjects with assigned disease status}
}
\value{
diseased subjects, \code{Population-class} object: a subset of control and vaccinated subjects with disease status = TRUE.
}
\description{
Function extracts diseased subjects from vaccinated and control groups if the data have assigned disease status (for example using \code{ClinicalTrial} function). The vaccinated and control data are provided in the form of population class objects (see the \code{Population-class} function for more details).
}
\examples{
## Example 1
# Data preparation
data(vaccinated)
data(control)

# Estimating the disease status and case-count efficacy with CI
ClinicalTrial(vaccinated, control, CI = 0.95)

# Extracting the disease cases
ExtractDiseased(vaccinated, control)

}
