% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_diff_interaction.R
\name{lr_linear_model_discrete}
\alias{lr_linear_model_discrete}
\title{Compare Ligand-Receptor Interaction Scores with Group Variable using Linear Regression}
\usage{
lr_linear_model_discrete(
  lr_scores,
  metadata,
  group_variable,
  ident1,
  ident2 = NULL,
  covariates = NULL,
  fdr_threshold = 0.05
)
}
\arguments{
\item{lr_scores}{Data frame containing LR interaction scores per sample (data frame).}

\item{metadata}{Data frame containing sample metadata (data frame).}

\item{group_variable}{Column name in \code{metadata} to compare groups (categorical or continuous) (character).}

\item{ident1}{If categorical, group to compare (coded as 1) (character).}

\item{ident2}{Reference group or list of groups (coded as 0). If None, uses all others (character).}

\item{covariates}{Optional list of covariate column names (character vector).}

\item{fdr_threshold}{Significance cutoff for adjusted p-values (numeric, default: 0.05).}
}
\value{
Data frame with ligand, receptor, sender, receiver, coef, p-values, and adjusted p-values.
}
\description{
Perform linear regression analysis to compare ligand-receptor (LR) interaction scores
across groups, handling both continuous and binary group variables (ident1 vs ident2 or all others).
}
\examples{
\donttest{
  data(lr_scores_eg)
  data(metadata_eg)

  res <- lr_linear_model_discrete(
    lr_scores = lr_scores_eg,
    metadata = metadata_eg,
    group_variable = "IFN_type",
    ident1 = "high",
    covariates = c("Age_group", "Sex")
    )

  head(res)
}
}
