% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom.covRob.R
\name{MycovRobMcd}
\alias{MycovRobMcd}
\title{Control settings for custom.covRob.Mcd}
\usage{
MycovRobMcd(
  alpha = 1/2,
  nsamp = 500,
  nmini = 300,
  kmini = 5,
  scalefn = "hrv2012",
  maxcsteps = 200,
  seed = NULL,
  tolSolve = 1e-14,
  wgtFUN = "01.original",
  beta,
  use.correction = TRUE
)
}
\arguments{
\item{alpha}{numeric parameter controlling the size of the subsets over 
which the determinant is minimized. Allowed values are between 
0.5 and 1 and the default is 0.5.}

\item{nsamp}{number of subsets used for initial estimates or "best", "exact", 
or "deterministic". Default is nsamp = 500. For nsamp = "best" 
exhaustive enumeration is done, as long as the number of trials 
does not exceed 100'000, which is the value of nlarge. For "exact", 
exhaustive enumeration will be attempted however many samples are needed.
In this case a warning message may be displayed saying that 
the computation can take a very long time.
For "deterministic", the deterministic MCD is computed; 
as proposed by Hubert et al. (2012) it starts from the h most 
central observations of six (deterministic) estimators.}

\item{nmini, kmini}{for n >= 2*n0, n0 := nmini, the algorithm splits the data 
into maximally kmini (by default 5) subsets, of size approximately, 
but at least nmini. When nmini*kmini < n, the initial search 
uses only a subsample of size nmini*kmini. The original algorithm 
had nmini = 300 and kmini = 5 hard coded.}

\item{scalefn}{function to compute a robust scale estimate or character string 
specifying a rule determining such a function for the deterministic MCD.
The default is "hrv2012". Another option value is "v2014".}

\item{maxcsteps}{maximal number of concentration steps in the deterministic MCD}

\item{seed}{initial seed for random generator}

\item{tolSolve}{numeric tolerance to be used for inversion of the covariance matrix}

\item{wgtFUN}{a character string or function, specifying how the weights for 
the reweighting step should be computed. Default is "01.originalz".}

\item{beta}{a quantile, experimentally used for some of the prespecified wgtFUNs. For our 
MCD method, the default is 0.975.}

\item{use.correction}{whether to use finite sample correction factors; defaults to TRUE.}
}
\value{
a list of passed parameters
}
\description{
Auxiliary function for passing the estimation options as parameters 
to the estimation function MCD.robust.moment
}
