% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_size.R
\name{SampleSize}
\alias{SampleSize}
\title{Sample Size Estimation}
\usage{
SampleSize(
  cens_prop = 0,
  med1 = NULL,
  shape1 = NULL,
  rate1 = NULL,
  med2 = NULL,
  shape2 = NULL,
  rate2 = NULL,
  info_reps = 50,
  min_n = 10,
  max_n = 100,
  margin = 0,
  target_prob = 0.8,
  use_exp_calc = TRUE
)
}
\arguments{
\item{cens_prop}{Expected censoring proportion.}

\item{med1}{Median for treatment arm 1, assuming shape1 is 1. Overwrites
shape and rate if supplied.}

\item{shape1}{Shape parameter for treatment arm 1.}

\item{rate1}{Rate parameter for treatment arm 1.}

\item{med2}{Median for treatment arm 2, assuming shape2 is 1. Overwrites
shape and rate if supplied.}

\item{shape2}{Shape parameter for treatment arm 2.}

\item{rate2}{Rate parameter for treatment arm 2.}

\item{info_reps}{Replicates used for estimating the observed information
matrix.}

\item{min_n}{Minimum allowable sample size.}

\item{max_n}{Maximum allowable sample size.}

\item{margin}{Margin of practical equivalence.}

\item{target_prob}{Probability of selecting the more effective treatment.}

\item{use_exp_calc}{If both shape parameters are 1, should the calculations
be performed assuming an exponential distribution for the time to event in
each arm? Default is TRUE.}
}
\value{
Integer sample size.
}
\description{
Estimate the sample size for a practical equivalence trial with a time to
event endpoint. The sample size is determined by specifying the time to event
distribution of each treatment arm, the margin of practical equivalence, and
the desired probability of selecting the superior treatment. The distribution
in each treatment arm may be specified either by providing the median, in
which case the time to event is assumed to be exponential, or by specifying
the shape and rate of a Weibull distribution. For guidance on how to set the
shape and rate parameters when using a Weibull calculation, see
\code{\link{WeibullSpec}}.
}
\examples{
# Sample size calculation based on exponentials. 
n <- SampleSize(
  cens_prop = 0.15,
  med1 = 9,
  med2 = 12
)

# Sample size calculation based on exponentials with a 2 month margin.
# Note that the required sample size is expected to increase.
n <- SampleSize(
  cens_prop = 0.15,
  med1 = 9,
  med2 = 12,
  margin = 2
)

# Sample size calculation based on Weibulls. 
n <- SampleSize(
  cens_prop = 0.15,
  shape1 = 2.8,
  rate1 = 0.10,
  shape2 = 4.0,
  rate2 = 0.08
)
}
