% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get.var}
\alias{get.var}
\title{\code{get.var}: Get indices}
\usage{
get.var(candidate.index, xs, ys, family, gvif)
}
\arguments{
\item{candidate.index}{Indices of the candidate set}

\item{xs}{Standardized independent variables}

\item{ys}{Standardized dependent variable}

\item{family}{A description of the error distribution and link function to be
used in the model. It can take the value of \verb{\code{gaussian}}, \verb{\code{binomial}},
\verb{\code{poisson}}, and \verb{\code{cox}}.}

\item{gvif}{A logical operator indicating whether a generalized variance inflation factor-adjusted
null bound is used. Default is FALSE.}
}
\value{
A list of following components:
\describe{
\item{out.sgpv}{A vector of indices of selected variables}
\item{null.bound.p}{Null bound in the SGPV screening}
\item{pe}{Point estimates in the candidate set}
\item{lb}{Lower bounds of effect estimates in the candidate set}
\item{ub}{Upper bounds of effect estimates in the candidate set}
}
}
\description{
Get the indices of the variables selected by the algorithm
}
