% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{simu_db}
\alias{simu_db}
\title{Generate a synthetic dataset tailored for ProteoBayes}
\usage{
simu_db(
  nb_peptide = 5,
  nb_group = 2,
  nb_sample = 5,
  multi_imp = FALSE,
  nb_draw = 5,
  range_peptide = c(0, 50),
  diff_group = 3,
  var_sample = 2,
  var_draw = 1
)
}
\arguments{
\item{nb_peptide}{An integer, indicating the number of peptides in the data.}

\item{nb_group}{An integer, indicating the number of groups/conditions.}

\item{nb_sample}{An integer, indicating the number of samples in the data
for each peptide (i.e the repetitions of the same experiment).}

\item{multi_imp}{A boolean, indicating whether multiple imputations have
been applied to obtain the dataset.}

\item{nb_draw}{A number, indicating the number of imputation procedures
applied to obtain this dataset.}

\item{range_peptide}{A 2-sized vector, indicating the range of values from
which to pick a mean value for each peptide.}

\item{diff_group}{A number, indicating the mean difference between
consecutive groups}

\item{var_sample}{A number, indicating the noise variance for each new
sample of a peptide.}

\item{var_draw}{A number, indicating the noise variance for each
imputation draw.}
}
\value{
A full dataset of synthetic data.
}
\description{
Simulate a complete training dataset, which may be representative of various
applications. Several flexible arguments allow adjustment of the number of
peptides, of groups, and samples in each experiment. The values of several
parameters controlling the data generation process can be modified.
}
\examples{

## Generate a dataset with 5 peptides in each of the 2 groups, observed for
##  3 different samples
data = simu_db(nb_peptide = 5, nb_group = 2, nb_sample = 3)

## Generate a dataset with 3 peptides in each of the 3 groups, observed for
## 4 different samples, for which 5 imputation draws are available.
data = simu_db(nb_peptide = 3, nb_group = 3, nb_sample = 4, nb_draw = 5)

}
