% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cusum.R
\name{cusum}
\alias{cusum}
\title{Generates CUSUM values for Rasch, 2PL and 3PL IRT model based on the Van Krimpen-Stoop & Meijer, (2002).}
\usage{
cusum(dat, ipar = NULL, abi = NULL, IRTmodel = "2PL")
}
\arguments{
\item{dat}{a nxp matrix with n participants and p items. Responses are in 0 1 format.}

\item{ipar}{a pxk matrix with given item parameters p items and k item parameters. ipar[,1] discrimination; ipar[,2] item difficulty; ipar[,3] guessing-parameter.}

\item{abi}{a vector n ability. If not provided, estimated using Expected a Posteriori method.}

\item{IRTmodel}{specify the IRT model ("1PL", "2PL", "3PL"). Default is "2PL"}
}
\value{
Returns matrix with with lower and upper cusum statistics for \code{dat}.
}
\description{
Generates CUSUM values for Rasch, 2PL and 3PL IRT model based on the Van Krimpen-Stoop & Meijer, (2002).
}
\examples{
data(ex2PL)
cusum(dat = ex2PL)
}
\references{
Van Krimpen-Stoop, E. M., & Meijer, R. R. (2002). Detection of person misfit in computerized adaptive tests with polytomous items. Applied Psychological Measurement, 26(2), 164-180.
}
