% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{merge}
\alias{merge}
\title{Merge all Members of Two Instances}
\usage{
merge(inst1, inst2)
}
\arguments{
\item{inst1}{instance to move members to}

\item{inst2}{instance to move members from}
}
\value{
Q7 instance, with environment identity of \code{inst1} and members from both instances.
}
\description{
All public and private members of instance 2 will be
copied to instance 1, overwriting any of the same names.
}
\examples{

Screamer <- type(function(words){
  scream <- function(){
    paste0(paste(words,
                 collapse = " "),
           "!!!")
  }
})

Whisperer <- type(function(words){
  whisper <- function(){
    paste0("shhhhhhh.....",
           paste(words,
                 collapse = " "),
           "...")
  }
})

p1 <- Screamer("I love you")
p1$scream()

p2 <- Whisperer("My parents came back")
p2$whisper()

p1 <- p1 \%>\% merge(p2)

# note the the "word" for both methods became that of p2
p1$whisper()
p1$scream()

}
