% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All_Selection_Algorithm_Code.R
\name{forward.selection}
\alias{forward.selection}
\title{Returns diet estimates corresponding to a sample of predators based on a
forward selection algorithm that chooses the prey species to be included in
the modelling.}
\usage{
forward.selection(
  pred.mat,
  prey.mat,
  cal.vec,
  FC,
  ext.fa,
  k = 2,
  min.spec = 5,
  starting.spec = NULL,
  silence = FALSE
)
}
\arguments{
\item{pred.mat}{matrix containing the FA signatures of the predators, where
each row corresponds to a predator and each column to a FA.}

\item{prey.mat}{data frame containing the FA signatures of the prey, where
each row corresponds to a single individual prey.
The first column must index the prey group, while the
remaining columns correspond to FAs.}

\item{cal.vec}{numeric vector of calibration coefficients corresponding to
the FAs contained in the modelling subset ext.fa. A vector of
ones in the length of ext.fa may be used for modelling
without calibration coefficients.}

\item{FC}{numeric vector of the average lipid contents for each prey
group, in the order of the \emph{alphabetized} prey groups.
vector of ones equal in length to the number of prey groups
may be used for modelling without adjustment for fat content.}

\item{ext.fa}{character vector containing the subset of FAs to be used in
modelling.}

\item{k}{scaling factor to be used in calculating the value of the
information criterion (IC). The default value of 2
corresponds to the Akaike Information Criterion. For a sample
of size n, k = log(n) corresponds to the Bayesian Information
Criterion. As this factor is numeric, values corresponding to
other IC may be used freely.}

\item{min.spec}{optional integer value specifying the minimum final model
size for forward selection. By default, forward selection
will add species to the model until the value of the chosen
IC ceases to improve. If this parameter is increased, forward
selection will add the best available species up to the
specified minimum model size before continuing with the
default selection process.}

\item{starting.spec}{optional character vector specifying the starting
species for the forward selection algorithm. Where known,
two or more species may be specified to ensure their
inclusion in the final model, reducing computation times
for the algorithm.  The default is NULL.}

\item{silence}{if true, additional information is printed. Default is false.}
}
\value{
A list with components:
\item{Diet_Estimates}{A matrix of the diet estimates for each predator where
each row corresponds to a predator and each column to a prey species. The
estimates are expressed as proportions summing to one.}
\item{Selection_Order}{A data frame summarizing each step of the algorithm,
giving the order of species selection and the corresponding IC values.}
\item{Selection_Tables}{A list containing a data frame for each step of the
selection process, providing the IC values associated with adding any one
candidate species at that step.}
}
\description{
Returns diet estimates corresponding to a sample of predators based on a
forward selection algorithm that chooses the prey species to be included in
the modelling.
}
\details{
The function uses a forward selection algorithm and the simplified
MLE method to choose the prey species to be included in the model and then
returns the diet estimates corresponding to these species.
}
\examples{

 ## This example takes some time to run.
 ## Please uncomment code below to run.

#library(dplyr)
#library(compositions)
## Package data: FAs
#data(FAset)
#fa.set = as.vector(unlist(FAset))

## Package data: Prey
#data(preyFAs)
#prey.sub=(preyFAs[,4:(ncol(preyFAs))])[fa.set]
#prey.sub=prey.sub/apply(prey.sub,1,sum)
#group=as.vector(preyFAs$Species)
#prey.sub = cbind(group,prey.sub)
#sort.preytype <- order(prey.sub[, 1])
#prey.matrix <- prey.sub[sort.preytype,]

## Package data: Predators
#data(predatorFAs)
#tombstone.info = predatorFAs[,1:4]
#predator.matrix = predatorFAs[,5:(ncol(predatorFAs))]
#npredators = nrow(predator.matrix)

## Package data: Fat content
#FC = preyFAs[,c(2,3)]
#FC = as.vector(tapply(FC$lipid,FC$Species,mean,na.rm=TRUE))

## Package data: Calibration coefficients
#data(CC)
#cal.vec = CC[,2]
#cal.mat = replicate(npredators, cal.vec)
#rownames(cal.mat) <- CC$FA
#names(cal.vec) <- rownames(cal.mat)

## QFASA (KL)
#sample.qfasa <- p.QFASA(predator.matrix,MEANmeth(prey.matrix),cal.mat,
#dist.meas = 1,gamma=1,FC,
#start.val = rep(1,nrow(MEANmeth(prey.matrix))),fa.set)

## Forward Selection
#sample.fs <- forward.selection(predator.matrix,prey.matrix,cal.vec,FC,fa.set,
#min.spec = 5,starting.spec = c("capelin", "herring"))
## Output
#fs.estimates <- sample.fs$`Diet Estimates`
}
\seealso{
\emph{backward.elimination()}
}
