% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/QFRM.R
\name{BS}
\alias{BS}
\title{Black-Scholes (BS) pricing model}
\usage{
BS(o = OptPx())
}
\arguments{
\item{o}{An \code{OptPx} object}
}
\value{
An original \code{OptPx} object with \code{BS} list as components of Black-Scholes formular.
  See \code{BS_Simple}.
}
\description{
a wrapper function for BS_Simple; uses \code{OptPx} object as input.
}
\examples{
#See Hull, p.338, Ex.15.6. #Create an option and price it
o = Opt(Style='Eu', Right='Call', S0 = 42, ttm = .5, K = 40)
o = BS( OptPx(o, r=.1, vol=.2, NSteps=NA))
o$PxBS #print call option price computed by Black-Scholes pricing model
o$BS$Px$Put #print put option price computed by Black-Scholes pricing model
}
\author{
Oleg Melnikov, Department of Statistics, Rice University, Spring 2015
}
\references{
Hull, J.C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall.
ISBN 978-0-13-345631-8, \url{http://www-2.rotman.utoronto.ca/~hull/ofod}. \url{http://amzn.com/0133456315}
}

