% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/VarianceSwap.R
\name{VarianceSwapBS}
\alias{VarianceSwapBS}
\title{Variance Swap valuation via Black-Scholes (BS) model}
\usage{
VarianceSwapBS(o = OptPx(Opt(Style = "VarianceSwap", Right = "Other", ttm =
  0.25, S0 = 1020), r = 0.04, q = 0.01), K = seq(800, 1200, 50),
  Vol = seq(0.2, 0.24, 0.005), notional = 10^8, varrate = 0.045)
}
\arguments{
\item{o}{An object of class \code{OptPx}}

\item{K}{A vector of non-negative strike prices}

\item{Vol}{a vector of non-negative, less than zero implied volatilities for the associated strikes}

\item{notional}{A numeric positive amount to be invested}

\item{varrate}{A numeric positive varaince rate to be swapped}
}
\value{
An object of class \code{OptPx} with value included
}
\description{
Variance Swap valuation via Black-Scholes (BS) model
}
\examples{
(o = VarianceSwapBS())$PxBS

o = Opt(Style="VarianceSwap",Right="Other",ttm=.25,S0=1020)
o = OptPx(o,r=.04,q=.01)
Vol = Vol=c(.29,.28,.27,.26,.25,.24,.23,.22,.21)
(o = VarianceSwapBS(o,K=seq(800,1200,50),Vol=Vol,notional=10^8,varrate=.045))$PxBS

o = Opt(Style="VarianceSwap",Right="Other",ttm=.25,S0=1020)
o = OptPx(o,r=.04,q=.01)
Vol=c(.2,.205,.21,.215,.22,.225,.23,.235,.24)
(o =VarianceSwapBS(o,K=seq(800,1200,50),Vol=Vol,notional=10^8,varrate=.045))$PxBS

o = Opt(Style="VarianceSwap",Right="Other",ttm=.1,S0=100)
o = OptPx(o,r=.03,q=.02)
Vol=c(.2,.19,.18,.17,.16,.15,.14,.13,.12)
(o =VarianceSwapBS(o,K=seq(80,120,5),Vol=Vol,notional=10^4,varrate=.03))$PxBS
}
\author{
Max Lee, Department of Statistics, Rice University, Spring 2015
}
\references{
Hull, J.C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall.
ISBN 978-0-13-345631-8, \url{http://www-2.rotman.utoronto.ca/~hull/ofod}.
}

