% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdq.condf.R
\name{rdq.condf}
\alias{rdq.condf}
\title{Conditional density estimation}
\usage{
rdq.condf(x, Q, bcoe, taus, taul, delta, cov)
}
\arguments{
\item{x}{a vector (or a matrix) of covariates.}

\item{Q}{a vector of estimated conditional quantiles.}

\item{bcoe}{quantile regression coefficient estimates.}

\item{taus}{a vector of quantiles of interest.}

\item{taul}{a vector of quantiles used for the conditional density estimation.
It is needed to estimate the tail parts of conditional density functions more precisely.}

\item{delta}{bandwidths for estimating the conditional density.}

\item{cov}{either 0 or 1. Set \code{cov=1} if covariates are present in the model;
otherwise set \code{cov=0}.}
}
\value{
conditional density function estimates
}
\description{
\code{rdq.condf} estimates conditional density functions by using the differencing method.
}
\examples{
n = 500
x = runif(n,min=-4,max=4)
d = (x > 0)
y = x + 0.3*(x^2) - 0.1*(x^3) + 1.5*d + rnorm(n)
tlevel = seq(0.1,0.9,by=0.1)
hh = rep(2,length(tlevel))

ab = rdq(y=y,x=x,d=d,x0=0,z0=NULL,tau=tlevel,h.tau=hh,cov=0)
delta = 0.186
fe = rdq.condf(x=x,Q=ab$qp.est,bcoe=ab$bcoe.p,taus=0.5,taul=tlevel,delta=delta,cov=0)


}
