% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdq.sim.R
\name{rdq.sim}
\alias{rdq.sim}
\title{Simulation the asymptotic distributions}
\usage{
rdq.sim(x, d, x0, z0, dz, cov, tt, hh, hh2, fxp, fxm, n.sim)
}
\arguments{
\item{x}{a vector (or a matrix) of covariates.}

\item{d}{a numeric vector, the treatment status.}

\item{x0}{the cutoff point.}

\item{z0}{the value of the covariates at which to evaluate the effects.}

\item{dz}{the number of covariates.}

\item{cov}{either 0 or 1. Set \emph{cov=1} if covariates are present in the model;
otherwise set \emph{cov=0}.}

\item{tt}{a vector of quantiles.}

\item{hh}{the bandwidth values (specified for each quantile level).}

\item{hh2}{the bandwidth values for the local quadratic quantile regression.}

\item{fxp}{conditional density estimates on the right side of \eqn{x_0}.}

\item{fxm}{conditional density estimates on the left side of \eqn{x_0}.}

\item{n.sim}{the number of simulation repetitions.}
}
\value{
A list with elements:
\describe{
\item{dcp}{realizations from the asymptotic distribution of the conditional quantile process, from the right side of \eqn{x_0}.}
\item{dcm}{realizations from the asymptotic distribution of the conditional quantile process, from the left side of \eqn{x_0}.}
\item{drp}{realizations from the asymptotic distribution of the bias corrected conditional quantile process, from the right side of \eqn{x_0}.}
\item{drm}{realizations from the asymptotic distribution of the bias corrected conditional quantile process, from the left side of \eqn{x_0}.}
}
}
\description{
\code{rdq.sim} produces iid draws from the asymptotic distribution of the conditional quantile process estimate.
}
\examples{
n = 500
x = runif(n,min=-4,max=4)
d = (x > 0)
y = x + 0.3*(x^2) - 0.1*(x^3) + 1.5*d + rnorm(n)
tlevel = seq(0.1,0.9,by=0.1)
tlevel2 = c(0.05,tlevel,0.95)
hh = rep(2,length(tlevel))
hh2 = rep(2,length(tlevel2))

ab = rdq(y=y,x=x,d=d,x0=0,z0=NULL,tau=tlevel2,h.tau=hh2,cov=0)
delta = c(0.05,0.09,0.14,0.17,0.19,0.17,0.14,0.09,0.05)
fp = rdq.condf(x=x,Q=ab$qp.est,bcoe=ab$bcoe.p,taus=tlevel,taul=tlevel2,delta,cov=0)
fm = rdq.condf(x=x,Q=ab$qm.est,bcoe=ab$bcoe.m,taus=tlevel,taul=tlevel2,delta,cov=0)
sa = QTE.RD:::rdq.sim(x=x,d=d,x0=0,z0=NULL,dz=0,cov=0,tt=tlevel,hh,hh,fxp=fp$ff,fxm=fm$ff,n.sim=200)

}
\keyword{internal}
