% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tauhat_func.R
\name{tauhat_func}
\alias{tauhat_func}
\title{Kernel-based Local Kaplan-Meier Estimator for the Conditional Probability of the Survival Time}
\usage{
tauhat_func(y0, x0, z, x, delta, bw)
}
\arguments{
\item{y0}{the vector of censored outcome of a single observation}

\item{x0}{the vector of given covariate of a single observation}

\item{z}{observed vector of response variable from observed data}

\item{x}{the observed matrix of covariates, the dimension is # of observations by number of covariates. 
Note that the vector of ones should NOT be included in \code{x}.}

\item{delta}{the vector of censoring indicators}

\item{bw}{the scalar bandwidth parameter in kernel}
}
\description{
This function estimates the value of
   \deqn{F(T <= y_0 \mid x_0),}
 the conditional cumulative distribution function of a survival time \eqn{T} 
 given covaraites vector \eqn{x_0} 
 at value \eqn{y_0}.
This estimator is described in detail in \insertCite{wang2009locally}{QTOCen}.
}
\details{
For cases with multivariate covariates, we adopted a product kernel. 
For example, in the bivariate case we use \deqn{K(x_1, x_2) = K_1(x_1) K_2(x_2),}
where \eqn{K_1} and \eqn{K_2} are both biquadratickernel functions.
}
\examples{
tauhat_func(y0=10, x0=c(2,3), z=c(10, 12, 11), 
            x=matrix(c(1,1,2,2,3,3), nrow=3, byrow=TRUE), 
            delta=c(1,1,0), bw=10)

}
\references{
\insertRef{wang2009locally}{QTOCen}
}
