% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_qploidy_standardization}
\alias{plot_qploidy_standardization}
\title{Plot Method for Qploidy Standardization}
\usage{
plot_qploidy_standardization(
  x,
  sample = NULL,
  chr = NULL,
  type = c("all", "het", "BAF", "zscore", "BAF_hist", "ratio", "BAF_hist_overall",
    "Ratio_hist_overall"),
  area_single = 0.75,
  ploidy = 4,
  dot.size = 1,
  font_size = 12,
  add_estimated_peaks = FALSE,
  add_expected_peaks = FALSE,
  centromeres = NULL,
  add_centromeres = FALSE,
  colors = FALSE,
  window_size = 2e+06,
  het_interval = 0.1,
  rm_homozygous = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class `qploidy_standardization`.}

\item{sample}{Character string indicating the sample ID to plot.}

\item{chr}{Character or numeric vector specifying the chromosomes to plot.
Default is NULL (plots all chromosomes).}

\item{type}{Character vector defining the plot types. Options include:
- "all": Generates all available plot types.
- "het": Plots heterozygous locus counts across genomic windows.
- "BAF": Plots B-allele frequency (BAF) for each chromosome.
- "zscore": Plots z-scores for each chromosome.
- "BAF_hist": Plots BAF histograms for each chromosome.
- "BAF_hist_overall": Plots a BAF histogram for the entire genome.
- "Ratio_hist_overall": Plots a histogram of raw ratios for the entire
genome.
- "ratio": Plots raw ratios for each chromosome.
Default is "all".}

\item{area_single}{Numeric value defining the area around the expected peak
to be considered. Default is 0.75.}

\item{ploidy}{Integer specifying the expected ploidy. Default is 4.}

\item{dot.size}{Numeric value for the size of the dots in the plots. Default
is 1.}

\item{font_size}{Numeric value for the font size of plot labels. Default is
12.}

\item{add_estimated_peaks}{Logical. If TRUE, adds lines for estimated peaks.
Default is FALSE.}

\item{add_expected_peaks}{Logical. If TRUE, adds lines for expected peaks.
Default is FALSE.}

\item{centromeres}{Named vector defining centromere positions for each
chromosome. Names must match chromosome IDs in `x`.}

\item{add_centromeres}{Logical. If TRUE, adds vertical lines at centromere
positions. Default is FALSE.}

\item{colors}{Logical. If TRUE, adds area colors to the plots. Default is
FALSE.}

\item{window_size}{Numeric value defining the genomic position window for
heterozygous locus counts. Default is 2000000.}

\item{het_interval}{Numeric value defining the interval to consider as
heterozygous. Default is 0.1.}

\item{rm_homozygous}{Logical. If TRUE, removes homozygous calls from BAF
histogram plots. Default is FALSE.}

\item{...}{Additional plot parameters.}
}
\value{
A ggarrange object containing the requested plots.
}
\description{
This function generates various plots for visualizing the results of Qploidy
standardization. It supports multiple plot types, including BAF, z-score,
and histograms.
}
\details{
The function supports the following plot types:

- **all**: Generates all available plot types.
- **het**: Plots the proportion of heterozygous loci across genomic windows,
useful for identifying regions with high or low heterozygosity.
- **BAF**: Plots the B-allele frequency (BAF) for each chromosome, showing
the distribution of allele frequencies.
- **zscore**: Plots z-scores for each chromosome, which can help identify
outliers or regions with unusual data distributions.
- **BAF_hist**: Plots histograms of BAF values for each chromosome,
providing a summary of allele frequency distributions.
- **BAF_hist_overall**: Plots a single histogram of BAF values for the
entire genome, summarizing allele frequency distributions genome-wide.
- **Ratio_hist_overall**: Plots a histogram of raw ratios for the entire
genome, useful for visualizing overall ratio distributions.
- **ratio**: Plots raw ratios for each chromosome, showing the distribution
of observed ratios.
}
