% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotMetric.R
\name{PlotMetric}
\alias{PlotMetric}
\title{Create a customizable ggplot for metrics}
\usage{
PlotMetric(
  calculation,
  x = "content",
  y = "RAF",
  fill_var = NULL,
  point = TRUE,
  box = TRUE,
  base_theme = theme_bw(),
  ...
)
}
\arguments{
\item{calculation}{A data frame containing the data to be plotted. Output of \code{GetCalculation}}

\item{x}{Character string specifying the column name for the x-axis. Default is "content".}

\item{y}{Character string specifying the column name for the y-axis. Default is "RAF".}

\item{fill_var}{The name of the column to be used for fill color, or a vector of colors.
If NULL, no fill color is applied. Default is NULL.}

\item{point}{Logical. If TRUE (default), adds jittered points to the plot.}

\item{box}{Logical. If TRUE (default), adds a boxplot to the plot.}

\item{base_theme}{A ggplot2 theme object. Default is theme_bw().}

\item{...}{Additional ggplot2 functions to be applied to the plot.}
}
\value{
A ggplot object.
}
\description{
This is wrapper function to generate a ggplot object with default options for boxplot and jittered points.
Additional ggplot2 functions can be applied to the plot.
}
\examples{
# Define the path to the plate data file
plate_path <- system.file("extdata/20240716_p3", 
                          file = '20240716_p3_plate.xlsx', 
                          package = "QuICSeedR")
  
# Read the plate data
plate <- readxl::read_xlsx(plate_path)

# Define the path to the raw data file
raw_path <- system.file("extdata/20240716_p3", 
                        file = '20240716_p3_raw.xlsx', 
                        package = "QuICSeedR")
# Read the raw data
raw <- readxl::read_xlsx(raw_path)

# Get replicate data
replicate <- GetReplicate(plate)

# Ensure time displayed as decimal hours
plate_time = ConvertTime(raw)

#Get metadata and display the few rows 
meta = CleanMeta(raw, plate, replicate)

#Clean data 
cleanraw <- CleanRaw(meta, raw, plate_time)

#Get calculations using positive controls to normalize values. 
calculation = GetCalculation(raw = cleanraw, meta, norm = TRUE, norm_ct = 'Pos')

#Default plot
PlotMetric(calculation)
           
}
