# Name   : print.R0.sR
# Desc   : A tweaked "print" function designed to easily print all R objects from
#          a R0.sR-class list (result of estimate.R()).
# Date   : 2012/04/17
# Update : 2023/03/03
# Author : Boelle, Obadia
###############################################################################


#' @title
#' Print method for objects of class `R0.sR`
#' 
#' @description
#' Prints summary statistics from [estimate.R()] outputs.
#' 
#' @details
#' For internal use.
#' 
#' Displays the estimated reproduction ratio of one or more estimation results 
#' generated by [estimate.R()].
#' 
#' @param x An estimated object, output from [estimate.R()] (class `R0.sR`).
#' @param ... Parameters passed to inner functions. 
#' 
#' @return
#' This function does not return any data.
#' Called for side effects.
#' 
#' @keywords internal
#' 
#' @author Pierre-Yves Boelle, Thomas Obadia



# Function declaration

print.R0.sR <- function(
    x, 
    ... 
)  
  
  # Code
  
{
  #Make sure x is of the right class.
  if (!inherits(x, "R0.sR")) {
    stop("'x' must be of class 'R0.sR'")
  }
  
  #Successive print of individual model
  if (exists("EG", where = x$estimates)) {
    print(x$estimates$EG, ...)
  }
  
  if (exists("ML", where = x$estimates)) {
    print(x$estimates$ML, ...)
  }
  
  if (exists("AR", where = x$estimates)) {
    print(x$estimates$AR, ...)
  }
  
  if (exists("TD", where = x$estimates)) {
    print(x$estimates$TD, ...)
  }
  
  if (exists("SB", where = x$estimates)) {
    print(x$estimates$SB, ...)
  }
}
