% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R0.S.R
\name{plot.R0.S}
\alias{plot.R0.S}
\title{Plot of sensitivity analyses.}
\usage{
\method{plot}{R0.S}(x, what = "heatmap", time.step = 1, skip = 5, ...)
}
\arguments{
\item{x}{Output of \code{\link[=sensitivity.analysis]{sensitivity.analysis()}} (class \code{R0.S})}

\item{what}{Specify the desired output. Can be \code{"heatmap"} (default), \code{"criterion"} or both.}

\item{time.step}{Optional. If date of first observation is specified, number of day between each incidence observation.}

\item{skip}{Number of results to ignore (time period in days) when looking for highest Rsquared value.}

\item{...}{Parameters passed to inner functions.}
}
\value{
A list with best R0 measure for each possible time period, along with corresponding begin/end dates.
\item{max.Rsquared}{The highest R-squared values.}
\item{best.R0.values}{The corresponding \eqn{R_{0}} values.}
\item{best.fit}{The best model fit as defined by the highest R-squared values among all returned.}
}
\description{
Generates the graphical output for an object generated through
\code{\link[=sensitivity.analysis]{sensitivity.analysis()}}.
}
\details{
For internal use. Called by \code{\link[base:plot]{base::plot()}} when applied to \code{R0.S} objects.
A plot will be shown and the best model fit will be returned.
}
\author{
Pierre-Yves Boelle, Thomas Obadia
}
\keyword{internal}
