% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{get_rafs_top_rep_tuples_from_popcnts}
\alias{get_rafs_top_rep_tuples_from_popcnts}
\title{Get top (i.e., most common) representatives's tuples from their popcnts}
\usage{
get_rafs_top_rep_tuples_from_popcnts(
  rep_tuples_popcnts,
  n_clusters,
  n_tuples = 1
)
}
\arguments{
\item{rep_tuples_popcnts}{tuples' popcnts for the chosen variant as obtained from \code{\link{get_rafs_rep_tuples_popcnts}}}

\item{n_clusters}{the desired number of clusters}

\item{n_tuples}{the desired number of top tuples}
}
\value{
A list of top tuples (each tuple being a vector of representatives).
}
\description{
This helper function works on results of \code{\link{get_rafs_rep_tuples_popcnts}}
to obtain the desired number of top (most common) representatives' tuples at the chosen number of clusters.
}
\examples{
library(MDFS)
mdfs_omp_set_num_threads(1)  # only to pass CRAN checks
data(madelon)
rafs_results <- run_rafs(madelon$data, madelon$decision, 2, c(12345))
rafs_rep_tuples_popcnts <- get_rafs_rep_tuples_popcnts(rafs_results, 5)
get_rafs_top_rep_tuples_from_popcnts(rafs_rep_tuples_popcnts$stig_single, 5)
}
