% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regu-est-c.r
\name{late.regu.cv}
\alias{late.regu.cv}
\title{Model-assisted inference for local average treatment effects (LATEs) with instrumental variables based on cross validation}
\usage{
late.regu.cv(fold, nrho = NULL, rho.seq = NULL, y, tr, iv, fx, gx, hx,
  arm = 2, d1 = NULL, d2 = NULL, ploss = "cal", yloss = "gaus",
  off = NULL, ...)
}
\arguments{
\item{fold}{A vector of length 3 giving the fold numbers for cross validation in instrument propensity score estimation, treatment and outcome regressions respectively.}

\item{nrho}{A vector of length 3 giving the numbers of tuning parameters searched in cross validation.}

\item{rho.seq}{A list of three vectors giving the tuning parameters in instrument propensity score estimation (first vector), treatment (second vector) and outcome (third vector) regressions.}

\item{y}{An \eqn{n} x \eqn{1} vector of observed outcomes.}

\item{tr}{An \eqn{n} x \eqn{1} vector of treatment indicators (=1 if treated or 0 if untreated).}

\item{iv}{An \eqn{n} x \eqn{1} vector of instruments (0 or 1).}

\item{fx}{An \eqn{n} x \eqn{p} matix of covariates, used in the instrument propensity score model.}

\item{gx}{An \eqn{n} x \eqn{q_1} matix of covariates, used in the treatment regression models. In theory, \code{gx} should be a subvector of \code{gx}, hence \eqn{p\leq q_1}.}

\item{hx}{An \eqn{n} x \eqn{q_2} matix of covariates, used in the outcome regression models. In theory, \code{hx} should be a subvector of \code{hx}, hence \eqn{p\leq q_2}.}

\item{arm}{An integer 0, 1 or 2 indicating whether \eqn{\theta_0}, \eqn{\theta_1} or both are computed; see \strong{Details} for \code{\link{late.aipw}}.}

\item{d1}{Degree of truncated polynomials of fitted values from treatment regression to be included as regressors in the outcome regression (NULL: no adjustment, 0: piecewise constant, 1: piecewise linear etc.).}

\item{d2}{Number of knots of fitted values from treatment regression to be included as regressors in the outcome regression, with knots specified as the \eqn{i}/(\code{d2}+1)-quantiles for \eqn{i}=1,...,\code{d2}.}

\item{ploss}{A loss function used in instrument propensity score estimation (either "ml" for likelihood estimation or "cal" for calibrated estimation).}

\item{yloss}{A loss function used in outcome regression (either "gaus" for continuous outcomes or "ml" for binary outcomes).}

\item{off}{A \eqn{2} x \eqn{1} vector of offset values (e.g., the true values in simulations) used to calculate the z-statistics from augmented IPW estimation.}

\item{...}{Additional arguments to \code{\link{glm.regu.cv}}.}
}
\value{
\item{ips}{A list containing the results from fitting the instrument propensity score models by \code{\link{glm.regu.cv}}.}
\item{mfp}{An \eqn{n} x \eqn{2} matrix of fitted instrument propensity scores for \code{iv}=0 (first column) and \code{iv}=1 (second column).}
\item{tps}{A list containing the results from fitting the treatment regression models by \code{\link{glm.regu.cv}}.}
\item{mft}{An \eqn{n} x \eqn{2} matrix of fitted treatment regression models for \code{iv}=0 (first column) and \code{iv}=1 (second column).}
\item{or}{A list containing the results from fitting the outcome regression models by \code{\link{glm.regu.cv}}.}
\item{mfo}{An \eqn{n} x \eqn{4} matrix of fitted outcome regression models for for \code{iv}=0, \code{tr}=0 (first column), \code{iv}=0, \code{tr}=1 (second column), \code{iv}=1, \code{tr}=0 (third column) and  \code{iv}=1, \code{tr}=1 (fourth column). Two columns are set to \code{NA} if \code{arm}=0 or 1.}
\item{est}{A list containing the results from augmented IPW estimation by \code{\link{late.aipw}}.}
}
\description{
This function implements model-assisted inference for LATEs with instrumental variables, using regularized calibrated estimation based on cross validation.
}
\details{
For \code{ploss}="cal", regularized calibrated estimation of the instrument propensity score (IPS) and regularized weighted likelihood estimation of the treatment and outcome regression models are performed. The method leads to model-assisted inference for LATE, in which condidence intervals are valid
with high-dimensional data if the IPS model is correctly specified, but the treatment and outcome regression models may be misspecified (Sun and Tan 2020). For \code{ploss}="ml", regularized maximum likelihood estimation is used (Chernozhukov et al. 2018). In this case, standard errors are only shown to be valid if the IPS, treatment and outcome models are all correctly specified.
}
\examples{
\donttest{
data(simu.iv.data)
n <- dim(simu.iv.data)[1]
p <- dim(simu.iv.data)[2]-3

y <- simu.iv.data[,1]
tr <- simu.iv.data[,2]
iv <- simu.iv.data[,3]
x <- simu.iv.data[,3+1:p]
x <- scale(x)

late.cv.rcal <- late.regu.cv(fold=5*c(1,1,1), nrho=(1+10)*c(1,1,1), rho.seq=NULL, 
                 y, tr, iv, fx=x, gx=x, hx=x, arm=2, d1=1, d2=3, ploss="cal", yloss="gaus")

matrix(unlist(late.cv.rcal$est), ncol=2, byrow=TRUE, 
dimnames=list(c("ipw", "or", "est", "var", "ze", 
 "late.est", "late.var", "late.ze"), c("theta1", "theta0")))
}

}
\references{
Chernozhukov, V., Chetverikov, D., Demirer, M., Duflo, E., Hansen, C., Newey, W. and Robins, J.M. (2018) Double/debiased machine learning for treatment and structural parameters, \emph{The Econometrics Journal}, 21, C1–C68.


Sun, B. and Tan, Z. (2020) High-dimensional model-assisted inference for local average treatment effects with instrumental variables, arXiv:2009.09286.
}
