% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalAPO.R
\name{CalAPO}
\alias{CalAPO}
\title{Point Estimation and Variance for the unit-level direct effect (ADE), marginal direct effect (MDE), and unit level spillover effect (ASE)}
\usage{
CalAPO(data)
}
\arguments{
\item{data}{A data frame containing the relevant variables. The names for the variables should be ``Z'' for the treatment assignment, ``Y'' for the treatment outcome, ``A'' for the treatment assignment mechanism, and ``id'' for the cluster ID. The variable for the cluster ID should be a factor.}
}
\value{
A list of class \code{CalAPO} which contains the following items:
\item{Y.hat}{ Estimate of the average potential outcomes. }
\item{ADE.est}{ Estimate of the unit level direct effect. }
\item{MDE.est}{ Estimate of the marginal direct effect. }
\item{ASE.est}{ Estimate of the unti level spillover effect. }
\item{cov.hat}{ Conservative covariance matrix for the estimated potential outcomes. }
\item{var.hat.ADE}{ Estimated variance of the ADE. }
\item{var.hat.MDE}{ Estimated variance of the MDE. }
\item{var.hat.ASE}{ Estimated variance of the ASE. }
}
\description{
This function calculates the estimated average potential outcomes Y(z,a), point estimates for the ADE, MDE, and ASE, and conservative covariance matrix estimates.
}
\details{
For the details of the method implemented by this function, see the
references.
}
\examples{
data(jd)
data_LTFC <- data.frame(jd$assigned, jd$pct0, jd$cdd6m, jd$anonale)
colnames(data_LTFC) <- c("Z", "A", "Y", "id")
test <- CalAPO(data_LTFC)
print(CalAPO(data_LTFC))

}
\references{
Zhichao Jiang, Kosuke Imai (2020).
\dQuote{Statistical Inference and Power Analysis for Direct and Spillover Effects in Two-Stage Randomized Experiments}, \emph{Technical Report}.
}
\author{
Kosuke Imai, Department of Statistics, Harvard University
\email{imai@harvard.edu}, \url{https://imai.fas.harvard.edu/};
Zhichao Jiang, School of Public Health and Health Sciences, University of Massachusetts Amherst
\email{zhichaojiang@umass.edu};
Karissa Huang, Department of Statistics, Harvard College
\email{krhuang@college.harvard.edu}
}
\keyword{experiments}
\keyword{randomized}
\keyword{two-stage}
