% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{calculate_virtual_factor_and_lambda_group}
\alias{calculate_virtual_factor_and_lambda_group}
\title{Helpfunction used in update_g()}
\usage{
calculate_virtual_factor_and_lambda_group(
  group,
  solve_FG_FG_times_FG,
  robust,
  NN_local,
  method_estimate_factors_local,
  g,
  vars_est,
  number_of_group_factors_local,
  number_of_common_factors_local,
  method_estimate_beta,
  factor_group,
  lambda,
  comfactor,
  Y,
  X,
  beta_est,
  verbose = FALSE
)
}
\arguments{
\item{group}{number of groups}

\item{solve_FG_FG_times_FG}{This is the same as groupfactor / T. It is only used in the Classical approach}

\item{robust}{robust or classical estimation of group membership}

\item{NN_local}{number of time series}

\item{method_estimate_factors_local}{specifies the robust algorithm to estimate factors: default is "macro"}

\item{g}{vector with estimated group membership for all individuals}

\item{vars_est}{number of variables that are included in the algorithm and have their coefficient estimated. This is usually equal to vars.}

\item{number_of_group_factors_local}{number of group factors to be estimated}

\item{number_of_common_factors_local}{number of common factors to be estimated}

\item{method_estimate_beta}{defines how beta is estimated. Default case is an estimated beta for each individual. Default value is "individual." Possible values are "homogeneous", "group" or "individual".}

\item{factor_group}{estimated group specific factors}

\item{lambda}{loadings of the estimated common factors}

\item{comfactor}{estimated common factors}

\item{Y}{Y: NxT dataframe with the panel data of interest}

\item{X}{X: NxTxp array containing the observable variables}

\item{beta_est}{estimated values of beta}

\item{verbose}{when TRUE, it prints messages}
}
\value{
NxT matrix containing the product of virtual groupfactors and virtual loadings
}
\description{
This function calculates FgLg (the groupfactorstructure) for all possible groups where individual i can be placed. For each group were
the groupfactors (Fg) estimated earlier. Now the grouploadings are needed for each group as well. In the classical case these are calculated by Fg*Y/T. In the robust case
these are robust.
}
