% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{iterate}
\alias{iterate}
\title{Wrapper around estimate_beta(), update_g(), and estimating the factorstructures.}
\usage{
iterate(
  Y,
  X,
  beta_est,
  g,
  lambda_group,
  factor_group,
  lambda,
  comfactor,
  S,
  k,
  kg,
  robust,
  method_estimate_beta = "individual",
  method_estimate_factors = "macro",
  verbose = FALSE
)
}
\arguments{
\item{Y}{Y: NxT dataframe with the panel data of interest}

\item{X}{X: NxTxp array containing the observable variables}

\item{beta_est}{estimated values of beta}

\item{g}{Vector with estimated group membership for all individuals}

\item{lambda_group}{loadings of the estimated group specific factors}

\item{factor_group}{estimated group specific factors}

\item{lambda}{loadings of the estimated common factors}

\item{comfactor}{estimated common factors}

\item{S}{number of groups to estimate}

\item{k}{number of common factors to estimate}

\item{kg}{vector with length S. Each element contains the number of group specific factors to estimate.}

\item{robust}{TRUE or FALSE: defines using the classical or robust algorithm to estimate beta}

\item{method_estimate_beta}{defines how beta is estimated. Default case is an estimated beta for each individual. Default value is "individual." Possible values are "homogeneous", "group" or "individual".}

\item{method_estimate_factors}{specifies the robust algorithm to estimate factors: default is "macro". The value is not used when robust is set to FALSE.}

\item{verbose}{when TRUE, it prints messages}
}
\value{
list with
\enumerate{
\item estimated beta
\item vector with group membership
\item matrix with the common factor(s) (contains zero's if there are none estimated)
\item loadings to the common factor(s)
\item list with the group specific factors for each of the groups
\item data.frame with loadings to the group specific factors augmented with group membership and id (to have the order of the time series)
\item the value of the objective function
}
}
\description{
Wrapper around estimate_beta(), update_g(), and estimating the factorstructures.
}
\examples{
set.seed(1)
original_data <- create_data_dgp2(30, 10)
Y <- original_data[[1]]
X <- original_data[[2]]
g <- original_data[[3]]
beta_est <- matrix(rnorm(4 * ncol(Y)), nrow = 4)
factor_group <- original_data[[5]]
lambda_group <- original_data[[6]]
comfactor <- matrix(0, nrow = 1, ncol = ncol(Y))
lambda <- matrix(0, nrow = 1, ncol = nrow(Y))
iterate(Y, X, beta_est, g, lambda_group, factor_group, lambda, comfactor, 3, 0, c(3, 3, 3), TRUE,
  verbose = FALSE)
}
