% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impact_eval.R
\name{impact_eval}
\alias{impact_eval}
\title{Impact Evaluation of Treatment Effects}
\usage{
impact_eval(
  data,
  endogenous_vars,
  treatment,
  heterogenous_vars,
  fixed_effect_vars = NULL,
  control_vars,
  cluster_var
)
}
\arguments{
\item{data}{A data.frame, tibble or data.table}

\item{endogenous_vars}{Vector of Y's on which treatment effects will be evaluated}

\item{treatment}{Variable indicating the treatment status}

\item{heterogenous_vars}{Vector of variables for which you wish to assess treatment distributions/heterogeneities.}

\item{fixed_effect_vars}{Vector of variables to add as fixed effects. Default is without fixed effects}

\item{control_vars}{Vector of variables to control for in the evaluation. Default is without controls}

\item{cluster_var}{String of cluster variable the standard errors. Default is without clustered std errors}
}
\value{
impact_eval() returns a list of regression tables. The names of the list are the same as the endogenous variables.
for heterogeneities the names are endogenous_var_heterogenous_var
}
\description{
Impact Evaluation of Treatment Effects
}
\details{
This function carries out the evaluation of treatment effects on endogenous variables. 
It automatically runs the regressions of all the endogenous_vars supplied & all the combinations 
of endogenous_vars and heterogenous_vars. Additionally, the function has the option of include 
fixed_effects, controls and cluster variables for clustered std errors.
}
\examples{
data <- data.frame(y_1 = rnorm(n = 100, mean = 100, sd = 15), 
                  y_2 = rnorm(n = 100, mean = 8, sd = 2), 
                  treat = rep(c(0,1,2,3), each = 25), 
                  heterogenous_var1 = rep(c("X_Q1", "X_Q2", "X_Q3", "X_Q4"), times = 25),
                  cluster_var1 = rep(c(1:5), times = 20), 
                  fixed_effect_var1 = rep(c(1,2), times = 50),
                  control_var1 = rnorm(n = 100, mean = 20, sd = 1))

evaluation<-impact_eval(data = data, 
                       endogenous_vars = c("y_1", "y_2"), 
                       treatment = "treat", 
                       heterogenous_vars = c("heterogenous_var1"), 
                       cluster_var = "cluster_var1", fixed_effect_vars = c("fixed_effect_var1"), 
                       control_vars = c("control_var1"))
}
