% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{MultiSuccessionPlot}
\alias{MultiSuccessionPlot}
\title{Successive Phases Density Plots (for phases in temporal order constraint)}
\usage{
MultiSuccessionPlot(data, position_minimum, position_maximum = position_minimum+1,
 level = 0.95, title = "Characterisation of a succession of phases")
}
\arguments{
  \item{data}{dataframe containing the output of the MCMC algorithm }
  \item{position_minimum}{numeric vector containing the column number corresponding to the minimum of the dates included in each phase}
  \item{position_maximum}{numeric vector containing the column number corresponding to the maximum of the dates included in each phase. By default, position_maximum = position_minimum + 1. 
}
  \item{level}{probability corresponding to the level of confidence}
  \item{title}{title of the graph}
}
\value{
Returns a plot of all densities and adds several summary statistics
}
\description{
This functions draws a plot of the densities of several successive phases and adds several statistics (mean, CI, HPDR)
}
\details{
Curves represent the density of the minimum (oldest dates) and the maximum (youngest dates) of the dates included in each phase. Curves of the same color refer to the same phase. When there is only one curve of one color, it means that there is only one event in the corresponding phase and then the minimum equals the maximum. Time range intervals are symbolised by segments above the curves drawn using the same color as the one of the curves of the associated phase. Transition and gap range intervals are represented by two-coloured segments using the colors of successive phases. If the gap between the successive phases does not exist, a cross is drawn instead of a segment. 
}
\author{
  Anne Philippe <Anne.Philippe@univ-nantes.fr> and

  Marie-Anne Vibet <Marie-Anne.Vibet@univ-nantes.fr>
}
\examples{
  # Data extracted from ChronoModel software
  data(Phases)
  
  # List of the name of the phases 
  names(Phases)
  
  # Stipulating position_end
  MultiSuccessionPlot(Phases, c(4,2), c(5,3), title = "Succession of phase 1 and phase 2")
  
  # In this case, equivalent to 
  MultiSuccessionPlot(Phases, c(4,2), title = "Succession of phase 1 and phase 2")
}
\keyword{ marginal posterior density }
\keyword{ gap between two phases }
\keyword{ transition between two phases }
\keyword{ phase time range }
\keyword{ temporal order }
\keyword{ succession of phases }
