% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitDegenerateConic.R
\name{splitDegenerateConic}
\alias{splitDegenerateConic}
\title{Split degenerate conic}
\source{
Richter-Gebert, Jürgen (2011). 
\emph{Perspectives on Projective Geometry - A Guided Tour Through Real
and Complex Geometry}, Springer, Berlin, ISBN: 978-3-642-17285-4
}
\usage{
splitDegenerateConic(C)
}
\arguments{
\item{C}{a \eqn{(3 \times 3)} matrix representation of a degenerate conic.}
}
\value{
A \eqn{(3 \times 2)} matrix whose columns correspond to the homongeneous representation of two lines (real or complex).
}
\description{
Split a degenerate conic into two lines.
}
\examples{
# tw0 lines
g <- c(0.75,0.25,3)
h <- c(0.5,-0.25,2)

# a degenerate conic 
D <- g \%*\% t(h) + h \%*\% t(g)

# split the degenerate conic into 2 lines
L <- splitDegenerateConic(D)

# plot
plot(0,0,xlim=c(-10,5),ylim=c(-10,10),type="n")
addLine(L[,1],col="red")
addLine(L[,2],col="green")
}
